/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.job;

import com.marklogic.client.pojo.annotation.Id;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.job.JobStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Job {
    private String jobId;
    private String flowType;
    private String flowName;
    private String entityName;
    private String jobName;
    private Date startTime;
    private Date endTime;
    private List<String> jobOutput;
    private JobStatus status = JobStatus.STARTED;
    private long successfulEvents = 0L;
    private long failedEvents = 0L;
    private long successfulBatches = 0L;
    private long failedBatches = 0L;

    private Job() {
        this.startTime = new Date();
    }

    public Job withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public static Job withFlow(Flow flow) {
        Job job = new Job();
        job.flowType = flow.getType().toString();
        job.flowName = flow.getName();
        job.entityName = flow.getEntityName();
        return job;
    }

    public Job withJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public Job withJobOutput(List<String> jobOutput) {
        this.jobOutput = jobOutput;
        return this;
    }

    public Job withJobOutput(String jobOutput) {
        if (this.jobOutput == null) {
            this.jobOutput = new ArrayList<String>();
        }
        this.jobOutput.add(jobOutput);
        return this;
    }

    public Job withStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public Job withEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public Job withStatus(JobStatus status) {
        this.status = status;
        return this;
    }

    public Job setCounts(long successfulEvents, long failedEvents, long successfulBatches, long failedBatches) {
        this.successfulEvents = successfulEvents;
        this.failedEvents = failedEvents;
        this.successfulBatches = successfulBatches;
        this.failedBatches = failedBatches;
        return this;
    }

    @Id
    public String getJobId() {
        return this.jobId;
    }

    public String getFlowType() {
        return this.flowType;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public List<String> getJobOutput() {
        return this.jobOutput;
    }

    public long getSuccessfulEvents() {
        return this.successfulEvents;
    }

    public long getFailedEvents() {
        return this.failedEvents;
    }

    public long getSuccessfulBatches() {
        return this.successfulBatches;
    }

    public long getFailedBatches() {
        return this.failedBatches;
    }
}

