/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.scaffold;

import com.marklogic.appdeployer.command.modules.AllButAssetsModulesFinder;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.io.Resource;

public class ScaffoldingValidator
extends SimpleFileVisitor<Path> {
    private static String UNIQUE_KEY = "unique";
    private Path pluginsDir;

    public ScaffoldingValidator(String projectDir) {
        this.pluginsDir = Paths.get(projectDir, "plugins");
    }

    public boolean isUniqueRestServiceExtension(final String name) {
        final HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put(UNIQUE_KEY, true);
        try {
            Files.walkFileTree(this.pluginsDir.resolve("entities"), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (ScaffoldingValidator.this.isRestDir(dir)) {
                        AllButAssetsModulesFinder modulesFinder = new AllButAssetsModulesFinder();
                        List services = modulesFinder.findModules(dir.toString()).getServices();
                        for (int i = 0; i < services.size(); ++i) {
                            Resource resource = (Resource)services.get(i);
                            if (!resource.getFilename().matches(name + "\\.(sjs|xqy)")) continue;
                            result.put(UNIQUE_KEY, false);
                            return FileVisitResult.TERMINATE;
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (Boolean)result.get(UNIQUE_KEY);
    }

    public boolean isUniqueRestTransform(final String name) {
        final HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put(UNIQUE_KEY, true);
        try {
            Files.walkFileTree(this.pluginsDir.resolve("entities"), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (ScaffoldingValidator.this.isRestDir(dir)) {
                        AllButAssetsModulesFinder modulesFinder = new AllButAssetsModulesFinder();
                        List transforms = modulesFinder.findModules(dir.toString()).getTransforms();
                        for (int i = 0; i < transforms.size(); ++i) {
                            Resource resource = (Resource)transforms.get(i);
                            if (!resource.getFilename().matches(name + "\\.(sjs|xqy)")) continue;
                            result.put(UNIQUE_KEY, false);
                            return FileVisitResult.TERMINATE;
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (Boolean)result.get(UNIQUE_KEY);
    }

    boolean isRestDir(Path dir) {
        return dir.endsWith("REST");
    }
}

