/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.scaffold.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.extensions.ResourceManager;
import com.marklogic.client.extensions.ResourceServices;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.util.RequestParameters;
import com.marklogic.hub.collector.impl.CollectorImpl;
import com.marklogic.hub.error.ScaffoldingValidationException;
import com.marklogic.hub.flow.CodeFormat;
import com.marklogic.hub.flow.DataFormat;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.flow.FlowBuilder;
import com.marklogic.hub.flow.FlowType;
import com.marklogic.hub.main.impl.MainPluginImpl;
import com.marklogic.hub.scaffold.Scaffolding;
import com.marklogic.hub.scaffold.ScaffoldingValidator;
import com.marklogic.hub.util.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ScaffoldingImpl
implements Scaffolding {
    private String projectDir;
    private Path pluginsDir;
    private Path entitiesDir;
    private ScaffoldingValidator validator;
    private DatabaseClient databaseClient;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ScaffoldingImpl(String projectDir, DatabaseClient databaseClient) {
        this.projectDir = projectDir;
        this.pluginsDir = Paths.get(this.projectDir, "plugins");
        this.entitiesDir = this.pluginsDir.resolve("entities");
        this.databaseClient = databaseClient;
        this.validator = new ScaffoldingValidator(projectDir);
    }

    public static String getAbsolutePath(String first, String ... more) {
        StringBuilder absolutePath = new StringBuilder(first);
        for (String path : more) {
            absolutePath.append(File.separator);
            absolutePath.append(path);
        }
        return absolutePath.toString();
    }

    @Override
    public Path getFlowDir(String entityName, String flowName, FlowType flowType) {
        Path entityDir = this.entitiesDir.resolve(entityName);
        Path typeDir = entityDir.resolve(flowType.toString());
        Path flowDir = typeDir.resolve(flowName);
        return flowDir;
    }

    @Override
    public void createEntity(String entityName) {
        Path entityDir = this.entitiesDir.resolve(entityName);
        entityDir.toFile().mkdirs();
    }

    @Override
    public void createFlow(String entityName, String flowName, FlowType flowType, CodeFormat codeFormat, DataFormat dataFormat) {
        this.createFlow(entityName, flowName, flowType, codeFormat, dataFormat, false);
    }

    @Override
    public void createFlow(String entityName, String flowName, FlowType flowType, CodeFormat codeFormat, DataFormat dataFormat, boolean useEsModel) {
        try {
            Path flowDir = this.getFlowDir(entityName, flowName, flowType);
            flowDir.toFile().mkdirs();
            if (flowType.equals((Object)FlowType.HARMONIZE)) {
                this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/collector." + (Object)((Object)codeFormat), flowDir.resolve("collector." + (Object)((Object)codeFormat)));
                this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/writer." + (Object)((Object)codeFormat), flowDir.resolve("writer." + (Object)((Object)codeFormat)));
            }
            if (useEsModel) {
                ContentPlugin cp = new ContentPlugin(this.databaseClient);
                String content = cp.getContents(entityName, codeFormat, flowType);
                this.writeBuffer(content, flowDir.resolve("content." + (Object)((Object)codeFormat)));
            } else {
                this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/content." + (Object)((Object)codeFormat), flowDir.resolve("content." + (Object)((Object)codeFormat)));
            }
            this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/headers." + (Object)((Object)codeFormat), flowDir.resolve("headers." + (Object)((Object)codeFormat)));
            this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/triples." + (Object)((Object)codeFormat), flowDir.resolve("triples." + (Object)((Object)codeFormat)));
            this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/main." + (Object)((Object)codeFormat), flowDir.resolve("main." + (Object)((Object)codeFormat)));
            Flow flow = FlowBuilder.newFlow().withEntityName(entityName).withName(flowName).withType(flowType).withCodeFormat(codeFormat).withDataFormat(dataFormat).build();
            FileWriter fw = new FileWriter(flowDir.resolve(flowName + ".properties").toFile());
            flow.toProperties().store(fw, "");
            fw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Document readLegacyFlowXml(File file) {
        try {
            FileInputStream is = new FileInputStream(file);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> updateLegacyFlows(String fromVersion, String entityName) {
        File[] harmonizeFlows;
        Path entityDir = this.entitiesDir.resolve(entityName);
        Path inputDir = entityDir.resolve("input");
        Path harmonizeDir = entityDir.resolve("harmonize");
        this.updateLegacyEntity(entityName);
        ArrayList<String> updatedFlows = new ArrayList<String>();
        File[] inputFlows = inputDir.toFile().listFiles(pathname -> pathname.isDirectory() && !pathname.getName().equals("REST"));
        if (inputFlows != null) {
            for (File inputFlow : inputFlows) {
                if (this.updateLegacyFlow(fromVersion, entityName, inputFlow.getName(), FlowType.INPUT)) {
                    updatedFlows.add(entityName + " => " + inputFlow.getName());
                    continue;
                }
                if (!this.update2xFlow(entityName, inputFlow.getName(), FlowType.INPUT)) continue;
                updatedFlows.add(entityName + " => " + inputFlow.getName());
            }
        }
        if ((harmonizeFlows = harmonizeDir.toFile().listFiles(pathname -> pathname.isDirectory() && !pathname.getName().equals("REST"))) != null) {
            for (File harmonizeFlow : harmonizeFlows) {
                if (this.updateLegacyFlow(fromVersion, entityName, harmonizeFlow.getName(), FlowType.HARMONIZE)) {
                    updatedFlows.add(entityName + " => " + harmonizeFlow.getName());
                    continue;
                }
                if (!this.update2xFlow(entityName, harmonizeFlow.getName(), FlowType.HARMONIZE)) continue;
                updatedFlows.add(entityName + " => " + harmonizeFlow.getName());
            }
        }
        return updatedFlows;
    }

    @Override
    public void updateLegacyEntity(String entityName) {
        Path entityDir = this.entitiesDir.resolve(entityName);
        File[] entityFiles = entityDir.toFile().listFiles((dir, name) -> name.matches("[^.]+\\.entity\\.json"));
        if (entityFiles != null && entityFiles.length == 0) {
            String fileContents = this.getFileContent("scaffolding/Entity.json", entityName);
            this.writeToFile(fileContents, entityDir.resolve(entityName + ".entity.json").toFile());
        }
    }

    @Override
    public boolean updateLegacyFlow(String fromVersion, String entityName, String flowName, FlowType flowType) {
        boolean updated = false;
        Path flowDir = this.getFlowDir(entityName, flowName, flowType);
        File[] mainFiles = flowDir.toFile().listFiles((dir, name) -> name.matches("main\\.(sjs|xqy)"));
        if (mainFiles.length < 1 || !flowDir.resolve(flowName + ".properties").toFile().exists()) {
            File[] files;
            for (File file : files = flowDir.toFile().listFiles((dir, name) -> name.endsWith(".xml"))) {
                Document doc = this.readLegacyFlowXml(file);
                if (!doc.getDocumentElement().getLocalName().equals("flow")) continue;
                DataFormat dataFormat = null;
                CodeFormat codeFormat = null;
                NodeList nodes = doc.getElementsByTagName("data-format");
                if (nodes.getLength() == 1) {
                    String format = nodes.item(0).getTextContent();
                    if (format.equals("application/json")) {
                        dataFormat = DataFormat.JSON;
                    } else if (format.equals("application/xml")) {
                        dataFormat = DataFormat.XML;
                    } else {
                        throw new RuntimeException("Invalid Data Format");
                    }
                }
                if (flowDir.resolve("content").resolve("content.sjs").toFile().exists()) {
                    codeFormat = CodeFormat.JAVASCRIPT;
                } else if (flowDir.resolve("content").resolve("content.xqy").toFile().exists()) {
                    codeFormat = CodeFormat.XQUERY;
                } else {
                    throw new RuntimeException("Invalid Code Format");
                }
                String suffix = "";
                if (fromVersion.startsWith("1.")) {
                    suffix = "-1x";
                }
                this.writeFile("scaffolding/" + (Object)((Object)flowType) + "/" + (Object)((Object)codeFormat) + "/main-legacy" + suffix + "." + (Object)((Object)codeFormat), flowDir.resolve("main." + (Object)((Object)codeFormat)));
                file.delete();
                FlowBuilder flowBuilder = FlowBuilder.newFlow().withEntityName(entityName).withName(flowName).withType(flowType).withCodeFormat(codeFormat).withDataFormat(dataFormat).withMain(new MainPluginImpl("main." + (Object)((Object)codeFormat), codeFormat));
                if (flowType.equals((Object)FlowType.HARMONIZE)) {
                    flowBuilder.withCollector(new CollectorImpl("collector/collector." + (Object)((Object)codeFormat), codeFormat));
                    if (codeFormat.equals((Object)CodeFormat.JAVASCRIPT)) {
                        this.updateLegacySjsWriter(flowDir);
                    }
                }
                Flow flow = flowBuilder.build();
                try {
                    FileWriter fw = new FileWriter(flowDir.resolve(flowName + ".properties").toFile());
                    flow.toProperties().store(fw, "");
                    fw.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                updated = true;
            }
        }
        return updated;
    }

    public boolean update2xFlow(String entityName, String flowName, FlowType flowType) {
        FileOutputStream fileOutputStream;
        String mainFile;
        boolean updated = false;
        Path flowDir = this.getFlowDir(entityName, flowName, flowType);
        Path mainPath = flowDir.resolve("main.sjs");
        Path xqyMainPath = flowDir.resolve("main.xqy");
        if (mainPath.toFile().exists()) {
            try {
                mainFile = FileUtils.readFileToString((File)mainPath.toFile());
                if (mainFile.contains("dhf.xqy")) {
                    mainFile = mainFile.replaceAll("dhf\\.xqy", "dhf.sjs");
                    if (flowType.equals((Object)FlowType.HARMONIZE)) {
                        Pattern pattern = Pattern.compile("dhf\\.runWriter\\(xdmp\\.function\\(null,\\s*'\\.(.*)/writer\\.sjs'\\),\\s*id,\\s*envelope,\\s*options\\);");
                        Matcher matcher = pattern.matcher(mainFile);
                        String writerPath = "";
                        if (matcher.find()) {
                            writerPath = matcher.group(1);
                        }
                        mainFile = mainFile.replaceFirst("(const\\s+triplesPlugin\\s*=\\s*require.*)", "$1\nconst writerPlugin = require('." + writerPath + "/writer.sjs');");
                        mainFile = mainFile.replaceFirst("dhf\\.runWriter\\(xdmp\\.function\\.+\\);", "dhf.runWriter(writerPlugin, id, envelope, options);");
                    }
                    fileOutputStream = new FileOutputStream(mainPath.toFile());
                    IOUtils.write((String)mainFile, (OutputStream)fileOutputStream);
                    fileOutputStream.close();
                    updated = true;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (mainPath.toFile().exists() || xqyMainPath.toFile().exists()) {
            if (xqyMainPath.toFile().exists()) {
                mainPath = xqyMainPath;
            }
            try {
                mainFile = FileUtils.readFileToString((File)mainPath.toFile());
                mainFile = mainFile.replaceFirst("com\\.marklogic\\.hub", "MarkLogic/data-hub-framework");
                fileOutputStream = new FileOutputStream(mainPath.toFile());
                IOUtils.write((String)mainFile, (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return updated;
    }

    private void updateLegacySjsWriter(Path flowDir) {
        Path writerFile = flowDir.resolve("writer").resolve("writer.sjs");
        if (writerFile.toFile().exists()) {
            try {
                String contents = FileUtils.readFileToString((File)writerFile.toFile());
                Pattern pattern = Pattern.compile("module.exports[^;]+;", 8);
                contents = pattern.matcher(contents).replaceAll("module.exports = write;");
                FileOutputStream fileOutputStream = new FileOutputStream(writerFile.toFile());
                IOUtils.write((String)contents, (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeFile(String srcFile, Path dstFile) {
        this.logger.info("writing: " + srcFile + " => " + dstFile.toString());
        if (!dstFile.toFile().exists()) {
            InputStream inputStream = Scaffolding.class.getClassLoader().getResourceAsStream(srcFile);
            FileUtil.copy(inputStream, dstFile.toFile());
        }
    }

    private void writeBuffer(String buffer, Path dstFile) {
        this.logger.info("writing: " + dstFile.toString());
        if (!dstFile.toFile().exists()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer.getBytes(StandardCharsets.UTF_8));
            FileUtil.copy(inputStream, dstFile.toFile());
        }
    }

    @Override
    public void createRestExtension(String entityName, String extensionName, FlowType flowType, CodeFormat codeFormat) throws ScaffoldingValidationException {
        this.logger.info(extensionName);
        if (!this.validator.isUniqueRestServiceExtension(extensionName)) {
            throw new ScaffoldingValidationException("A rest service extension with the same name as " + extensionName + " already exists.");
        }
        String scaffoldRestServicesPath = "scaffolding/rest/services/";
        String fileContent = this.getFileContent(scaffoldRestServicesPath + (Object)((Object)codeFormat) + "/template." + (Object)((Object)codeFormat), extensionName);
        File dstFile = this.createEmptyRestExtensionFile(entityName, extensionName, flowType, codeFormat);
        this.writeToFile(fileContent, dstFile);
        this.writeMetadataForFile(dstFile, scaffoldRestServicesPath + "metadata/template.xml", extensionName);
    }

    @Override
    public void createRestTransform(String entityName, String transformName, FlowType flowType, CodeFormat codeFormat) throws ScaffoldingValidationException {
        this.logger.info(transformName);
        if (!this.validator.isUniqueRestTransform(transformName)) {
            throw new ScaffoldingValidationException("A rest transform with the same name as " + transformName + " already exists.");
        }
        String scaffoldRestTransformsPath = "scaffolding/rest/transforms/";
        String fileContent = this.getFileContent(scaffoldRestTransformsPath + (Object)((Object)codeFormat) + "/template." + (Object)((Object)codeFormat), transformName);
        File dstFile = this.createEmptyRestTransformFile(entityName, transformName, flowType, codeFormat);
        this.writeToFile(fileContent, dstFile);
        this.writeMetadataForFile(dstFile, scaffoldRestTransformsPath + "metadata/template.xml", transformName);
    }

    private void writeToFile(String fileContent, File dstFile) {
        try {
            FileWriter fw = new FileWriter(dstFile);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(fileContent);
            bw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File createEmptyRestExtensionFile(String entityName, String extensionName, FlowType flowType, CodeFormat codeFormat) {
        Path restDir = this.getRestDirectory(entityName, flowType);
        return this.createEmptyFile(restDir, "services", extensionName + "." + (Object)((Object)codeFormat));
    }

    private File createEmptyRestTransformFile(String entityName, String transformName, FlowType flowType, CodeFormat codeFormat) {
        Path restDir = this.getRestDirectory(entityName, flowType);
        return this.createEmptyFile(restDir, "transforms", transformName + "." + (Object)((Object)codeFormat));
    }

    private File createEmptyFile(Path directory, String subDirectoryName, String fileName) {
        Path fileDirectory = directory;
        if (subDirectoryName != null) {
            fileDirectory = directory.resolve(subDirectoryName);
        }
        fileDirectory.toFile().mkdirs();
        File file = fileDirectory.resolve(fileName).toFile();
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    public Path getEntityDir(String entityName) {
        return this.entitiesDir.resolve(entityName);
    }

    private Path getRestDirectory(String entityName, FlowType flowType) {
        return this.getFlowDir(entityName, "REST", flowType);
    }

    private void writeMetadataForFile(File file, String metadataTemplatePath, String metadataName) {
        String fileContent = this.getFileContent(metadataTemplatePath, metadataName);
        File metadataFile = this.createEmptyMetadataForFile(file, metadataName);
        this.writeToFile(fileContent, metadataFile);
    }

    private File createEmptyMetadataForFile(File file, String metadataName) {
        File metadataDir = new File(file.getParentFile(), "metadata");
        metadataDir.mkdir();
        File metadataFile = new File(metadataDir, metadataName + ".xml");
        try {
            metadataFile.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return metadataFile;
    }

    private String getFileContent(String srcFile, String placeholder) {
        StringBuilder output = new StringBuilder();
        InputStream inputStream = null;
        BufferedReader rdr = null;
        try {
            inputStream = Scaffolding.class.getClassLoader().getResourceAsStream(srcFile);
            rdr = new BufferedReader(new InputStreamReader(inputStream));
            String bufferedLine = null;
            while ((bufferedLine = rdr.readLine()) != null) {
                if (bufferedLine.contains("placeholder")) {
                    bufferedLine = bufferedLine.replace("placeholder", placeholder);
                }
                output.append(bufferedLine);
                output.append("\n");
            }
            inputStream.close();
            rdr.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toString();
    }

    public class ContentPlugin
    extends ResourceManager {
        private static final String NAME = "ml:scaffoldContent";
        private RequestParameters params = new RequestParameters();

        public ContentPlugin(DatabaseClient client) {
            client.init(NAME, (ResourceManager)this);
        }

        public String getContents(String entityName, CodeFormat codeFormat, FlowType flowType) {
            this.params.add("entity", entityName);
            this.params.add("codeFormat", codeFormat.toString());
            this.params.add("flowType", flowType.toString());
            ResourceServices.ServiceResultIterator resultItr = this.getServices().get(this.params, new String[0]);
            if (resultItr == null || !resultItr.hasNext()) {
                throw new RuntimeException("Unable to get Content Plugin scaffold");
            }
            ResourceServices.ServiceResult res = (ResourceServices.ServiceResult)resultItr.next();
            return ((StringHandle)res.getContent((AbstractReadHandle)new StringHandle())).get().replaceAll("\n", "\r\n");
        }
    }
}

