/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.util;

import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.modulesloader.ModulesManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Properties;

public class HubModuleManager
extends LoggingObject
implements ModulesManager {
    public static final String DEFAULT_FILE_PATH = "build/ml-javaclient-util/module-timestamps.properties";
    private Properties props = new Properties();
    private String propertiesFilePath;
    private long minimumFileTimestampToLoad;

    public HubModuleManager(String propertiesFilePath) {
        this.propertiesFilePath = propertiesFilePath;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        File propertiesFile = new File(this.propertiesFilePath);
        propertiesFile.getParentFile().mkdirs();
        if (propertiesFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propertiesFile);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Loading properties from: " + propertiesFile.getAbsolutePath());
                }
                this.props.load(fis);
            }
            catch (Exception e) {
                this.logger.warn("Unable to load properties, cause: " + e.getMessage());
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    this.logger.warn(e.getMessage());
                }
            }
        }
    }

    public void deletePropertiesFile() {
        File propertiesFile = new File(this.propertiesFilePath);
        if (propertiesFile.exists()) {
            propertiesFile.delete();
            this.props.clear();
        }
    }

    public boolean hasFileBeenModifiedSinceLastLoaded(File file) {
        if (this.minimumFileTimestampToLoad > 0L && file.lastModified() <= this.minimumFileTimestampToLoad) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("lastModified for file '%s' is %d, which is before the minimumFileTimestampToLoad of %d", file.getAbsolutePath(), file.lastModified(), this.minimumFileTimestampToLoad));
            }
            return false;
        }
        String key = this.buildKey(file);
        return this.hasKeyBeenModified(key, file.lastModified());
    }

    public boolean hasKeyBeenModified(String key, long lastModified) {
        String value = this.props.getProperty(key);
        if (value != null) {
            long lastLoaded = Long.parseLong(value);
            return lastModified > lastLoaded;
        }
        return true;
    }

    public void saveLastLoadedTimestamp(File file, Date date) {
        String key = this.buildKey(file);
        this.saveLastLoadedTimestamp(key, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLastLoadedTimestamp(String key, Date date) {
        this.props.setProperty(key, date.getTime() + "");
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(new File(this.propertiesFilePath));
            this.props.store(fw, "");
        }
        catch (Exception e) {
            this.logger.warn("Unable to store properties, cause: " + e.getMessage());
        }
        finally {
            try {
                fw.close();
            }
            catch (Exception e) {
                this.logger.warn(e.getMessage());
            }
        }
    }

    protected String buildKey(File file) {
        return file.getAbsolutePath().toLowerCase();
    }

    public void setMinimumFileTimestampToLoad(long minimumFileTimestampToLoad) {
        this.minimumFileTimestampToLoad = minimumFileTimestampToLoad;
    }
}

