/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class JsonXor {
    public static JsonNode xor(File original, File changed) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode originalTree = (ObjectNode)objectMapper.readTree(original);
        ObjectNode changedTree = (ObjectNode)objectMapper.readTree(changed);
        return JsonXor.xor(originalTree, changedTree);
    }

    public static JsonNode xor(InputStream original, InputStream changed) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode originalTree = (ObjectNode)objectMapper.readTree(original);
        ObjectNode changedTree = (ObjectNode)objectMapper.readTree(changed);
        return JsonXor.xor(originalTree, changedTree);
    }

    private static JsonNode xor(ObjectNode originalTree, ObjectNode changedTree) {
        ObjectNode xored = JsonNodeFactory.instance.objectNode();
        Iterator fieldItr = changedTree.fieldNames();
        while (fieldItr.hasNext()) {
            String key = (String)fieldItr.next();
            if (originalTree.has(key)) {
                JsonNode orig = originalTree.get(key);
                JsonNode changed = changedTree.get(key);
                if (orig.isArray()) {
                    ArrayNode array = JsonXor.xor((ArrayNode)orig, (ArrayNode)changed);
                    if (array.size() <= 0) continue;
                    xored.set(key, (JsonNode)array);
                    continue;
                }
                if (orig.isObject()) {
                    xored.set(key, JsonXor.xor((ObjectNode)orig, (ObjectNode)changed));
                    continue;
                }
                if (orig.equals((Object)changed)) continue;
                xored.set(key, changed);
                continue;
            }
            xored.set(key, changedTree.get(key));
        }
        return xored;
    }

    private static ArrayNode xor(ArrayNode originalArray, ArrayNode changedTree) {
        ArrayNode xored = JsonNodeFactory.instance.arrayNode();
        for (int i = 0; i < changedTree.size(); ++i) {
            boolean found = false;
            JsonNode changedNode = changedTree.get(i);
            for (int j = 0; j < originalArray.size(); ++j) {
                if (!originalArray.get(j).equals((Object)changedNode)) continue;
                found = true;
                break;
            }
            if (found) continue;
            xored.add(changedNode);
        }
        return xored;
    }
}

