/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.util;

import com.marklogic.hub.flow.FlowStatusListener;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MlcpConsumer
implements Consumer<String> {
    private int currentPc = 0;
    private static final Pattern COMPLETED_PATTERN = Pattern.compile("^.+completed (\\d+)%$");
    private static final Pattern SUCCESSFUL_EVENTS_PATTERN = Pattern.compile("^.+OUTPUT_RECORDS_COMMITTED:\\s+(\\d+).*$");
    private static final Pattern FAILED_EVENTS_PATTERN = Pattern.compile("^.+OUTPUT_RECORDS_FAILED\\s+(\\d+).*$");
    private AtomicLong successfulEvents;
    private AtomicLong failedEvents;
    private FlowStatusListener statusListener;
    private String jobId;

    public MlcpConsumer(AtomicLong successfulEvents, AtomicLong failedEvents, FlowStatusListener statusListener, String jobId) {
        this.successfulEvents = successfulEvents;
        this.failedEvents = failedEvents;
        this.statusListener = statusListener;
        this.jobId = jobId;
    }

    @Override
    public void accept(String status) {
        int pc;
        Matcher m = COMPLETED_PATTERN.matcher(status);
        if (m.matches() && (pc = Integer.parseInt(m.group(1))) > this.currentPc && pc != 100) {
            this.currentPc = pc;
        }
        if ((m = SUCCESSFUL_EVENTS_PATTERN.matcher(status)).matches()) {
            this.successfulEvents.addAndGet(Long.parseLong(m.group(1)));
        }
        if ((m = FAILED_EVENTS_PATTERN.matcher(status)).matches()) {
            this.failedEvents.addAndGet(Long.parseLong(m.group(1)));
        }
        if (this.statusListener != null) {
            this.statusListener.onStatusChange(this.jobId, this.currentPc, status);
        }
    }
}

