/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.DatabaseClient;
import com.marklogic.contentpump.bean.MlcpBean;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.flow.FlowStatusListener;
import com.marklogic.hub.job.Job;
import com.marklogic.hub.job.JobManager;
import com.marklogic.hub.job.JobStatus;
import com.marklogic.hub.util.MlcpConsumer;
import com.marklogic.hub.util.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MlcpRunner
extends ProcessRunner {
    private static Logger logger = LoggerFactory.getLogger(MlcpRunner.class);
    private JobManager jobManager;
    private Flow flow;
    private JsonNode mlcpOptions;
    private String jobId = UUID.randomUUID().toString();
    private AtomicLong successfulEvents = new AtomicLong(0L);
    private AtomicLong failedEvents = new AtomicLong(0L);
    FlowStatusListener flowStatusListener;
    private String mlcpPath;
    private String mainClass;
    private DatabaseClient databaseClient;

    public MlcpRunner(String mlcpPath, String mainClass, HubConfig hubConfig, Flow flow, DatabaseClient databaseClient, JsonNode mlcpOptions, FlowStatusListener statusListener) {
        this.withHubconfig(hubConfig);
        this.jobManager = JobManager.create(hubConfig.newJobDbClient(), hubConfig.newTraceDbClient());
        this.flowStatusListener = statusListener;
        this.flow = flow;
        this.mlcpOptions = mlcpOptions;
        this.mlcpPath = mlcpPath;
        this.mainClass = mainClass;
        this.databaseClient = databaseClient;
    }

    public String getJobId() {
        return this.jobId;
    }

    @Override
    public void run() {
        HubConfig hubConfig = this.getHubConfig();
        Job job = Job.withFlow(this.flow).withJobId(this.jobId);
        this.jobManager.saveJob(job);
        try {
            MlcpBean bean = (MlcpBean)new ObjectMapper().readerFor(MlcpBean.class).readValue(this.mlcpOptions);
            bean.setHost(this.databaseClient.getHost());
            bean.setPort(Integer.valueOf(this.databaseClient.getPort()));
            bean.setUsername(hubConfig.getAppConfig().getAppServicesUsername());
            bean.setPassword(hubConfig.getAppConfig().getAppServicesPassword());
            File file = new File(this.mlcpOptions.get("input_file_path").asText());
            String canonicalPath = file.getCanonicalPath();
            bean.setInput_file_path(canonicalPath);
            bean.setTransform_param("\"" + bean.getTransform_param() + ",job-id=" + this.jobId + "\"");
            bean.setModules_root("/");
            this.buildCommand(bean);
            super.run();
            if (this.flowStatusListener != null) {
                this.flowStatusListener.onStatusChange(this.jobId, 100, "");
            }
        }
        catch (Exception e) {
            job.withStatus(JobStatus.FAILED).withEndTime(new Date());
            this.jobManager.saveJob(job);
            throw new RuntimeException(e);
        }
        finally {
            JobStatus status = this.failedEvents.get() > 0L && this.successfulEvents.get() > 0L ? JobStatus.FINISHED_WITH_ERRORS : (this.failedEvents.get() == 0L && this.successfulEvents.get() > 0L ? JobStatus.FINISHED : JobStatus.FAILED);
            job.withJobOutput(this.getProcessOutput()).withStatus(status).setCounts(this.successfulEvents.get(), this.failedEvents.get(), 0L, 0L).withEndTime(new Date());
            this.jobManager.saveJob(job);
        }
    }

    private String buildLoggerconfig() {
        return "<configuration>\n\n  <appender name=\"STDOUT\" class=\"ch.qos.logback.core.ConsoleAppender\">\n    <!-- encoders are assigned the type\n         ch.qos.logback.classic.encoder.PatternLayoutEncoder by default -->\n    <encoder>\n      <pattern>%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n</pattern>\n    </encoder>\n  </appender>\n\n  <logger name=\"org.apache.http\" level=\"WARN\"/>\n\n  <logger name=\"com.marklogic.spring.batch.core.repository.dao.MarkLogicStepExecutionDao\" level=\"WARN\"/>\n  <logger name=\"com.marklogic.spring.batch.core.repository.dao.MarkLogicJobExecutionDao\" level=\"WARN\"/>\n  <logger name=\"com.marklogic.client.impl.DocumentManagerImpl\" level=\"WARN\"/>\n  <logger name=\"com.marklogic.client.impl.DatabaseClientImpl\" level=\"WARN\"/>\n  <logger name=\"com.marklogic\" level=\"INFO\"/>\n  <logger name=\"com.marklogic.appdeployer\" level=\"INFO\"/>\n  <logger name=\"com.marklogic.hub\" level=\"INFO\"/>\n  <logger name=\"com.marklogic.contentpump\" level=\"INFO\"/>\n  <logger name=\"org.apache.catalina.webresources.Cache\" level=\"ERROR\"/>\n  <logger name=\"org.apache.hadoop.util.Shell\" level=\"OFF\"/>\n  <logger name=\"org.apache.hadoop.util.NativeCodeLoader\" level=\"ERROR\"/>\n\n  <root level=\"WARN\">\n    <appender-ref ref=\"STDOUT\" />\n  </root>\n</configuration>\n";
    }

    private void buildCommand(MlcpBean bean) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        if (this.mlcpPath != null && this.mlcpPath.length() > 0) {
            File mlcpFile = new File(this.mlcpPath);
            if (!mlcpFile.exists()) {
                throw new RuntimeException("MLCP does not exist at: " + this.mlcpPath);
            }
            if (!mlcpFile.canExecute()) {
                throw new RuntimeException("Cannot execute: " + this.mlcpPath);
            }
            args.add(this.mlcpPath);
        } else {
            String javaHome = System.getProperty("java.home");
            String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
            String classpath = System.getProperty("java.class.path");
            List<String> classpathEntries = Arrays.asList(classpath.split(File.pathSeparator));
            String filteredClasspathEntries = classpath;
            int MAX_CLASSPATH_LENGTH = 10000;
            if (filteredClasspathEntries.length() > MAX_CLASSPATH_LENGTH) {
                filteredClasspathEntries = classpathEntries.stream().filter(u -> u.contains("jdk") || u.contains("jre") || u.contains("log") || u.contains("xml") || u.contains("json") || u.contains("jackson") || u.contains("xerces") || u.contains("slf") || u.contains("mlcp") || u.contains("xcc") || u.contains("xpp") || u.contains("protobuf") || u.contains("mapreduce") || u.contains("guava") || u.contains("apache") || u.contains("commons") || u.contains("hadoop")).collect(Collectors.joining(File.pathSeparator));
            }
            File loggerFile = File.createTempFile("mlcp-", "-logger.xml");
            FileUtils.writeStringToFile((File)loggerFile, (String)this.buildLoggerconfig());
            args.add(javaBin);
            args.add("-Dlogback.configurationFile=" + loggerFile.toURI());
            if (classpath.endsWith(".war")) {
                args.add("-jar");
                args.add(classpath);
                args.add("mlcp");
            } else {
                args.add("-cp");
                args.add(filteredClasspathEntries);
                args.add(this.mainClass);
            }
        }
        args.addAll(Arrays.asList(bean.buildArgs()));
        this.withArgs(args);
        this.withStreamConsumer(new MlcpConsumer(this.successfulEvents, this.failedEvents, this.flowStatusListener, this.jobId));
    }
}

