/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.util;

import com.marklogic.hub.HubConfig;
import com.marklogic.hub.util.StreamGobbler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRunner
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private HubConfig hubConfig;
    private ArrayList<String> processOutput = new ArrayList();
    private List<String> args;
    private Consumer<String> consumer;

    public HubConfig getHubConfig() {
        return this.hubConfig;
    }

    public String getProcessOutput() {
        return String.join((CharSequence)"\n", this.processOutput);
    }

    public static ProcessRunner newRunner() {
        return new ProcessRunner();
    }

    public ProcessRunner withArgs(List<String> args) {
        this.args = args;
        return this;
    }

    public ProcessRunner withHubconfig(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
        return this;
    }

    public ProcessRunner withStreamConsumer(Consumer<String> consumer) {
        this.consumer = consumer;
        return this;
    }

    @Override
    public void run() {
        try {
            this.logger.error(String.join((CharSequence)" ", this.args));
            ProcessBuilder pb = new ProcessBuilder(this.args);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            StreamGobbler gobbler = new StreamGobbler(process.getInputStream(), status -> {
                ArrayList<String> arrayList = this.processOutput;
                synchronized (arrayList) {
                    this.processOutput.add((String)status);
                }
                this.consumer.accept((String)status);
            });
            gobbler.start();
            process.waitFor();
            gobbler.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

