/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.util;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.eval.EvalResultIterator;
import com.marklogic.client.eval.ServerEvaluationCall;
import com.marklogic.client.extensions.ResourceManager;
import com.marklogic.client.extensions.ResourceServices;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.util.RequestParameters;
import com.marklogic.hub.HubConfig;

public class Versions
extends ResourceManager {
    private static final String NAME = "ml:hubversion";
    DatabaseClient appServicesClient;
    DatabaseClient stagingClient;

    public Versions(HubConfig hubConfig) {
        this.appServicesClient = hubConfig.newAppServicesClient();
        this.stagingClient = hubConfig.newStagingClient();
        this.stagingClient.init(NAME, (ResourceManager)this);
    }

    public String getHubVersion() {
        try {
            ResourceServices.ServiceResultIterator resultItr = this.getServices().get(new RequestParameters(), new String[0]);
            if (resultItr == null || !resultItr.hasNext()) {
                return null;
            }
            ResourceServices.ServiceResult res = (ResourceServices.ServiceResult)resultItr.next();
            return ((StringHandle)res.getContent((AbstractReadHandle)new StringHandle())).get();
        }
        catch (Exception exception) {
            return "2.0.0";
        }
    }

    public String getMarkLogicVersion() {
        String xqy;
        ServerEvaluationCall eval = this.appServicesClient.newServerEval();
        EvalResultIterator result = eval.xquery(xqy = "xdmp:version()").eval();
        if (result.hasNext()) {
            return result.next().getString();
        }
        throw new RuntimeException("Couldn't determine MarkLogic Version");
    }

    public static int compare(String v1, String v2) {
        if (v1 == null || v2 == null) {
            return 1;
        }
        String[] v1Parts = v1.split("\\.");
        String[] v2Parts = v2.split("\\.");
        int length = Math.max(v1Parts.length, v2Parts.length);
        for (int i = 0; i < length; ++i) {
            int v2Part;
            int v1Part = i < v1Parts.length ? Integer.parseInt(v1Parts[i]) : 0;
            int n = v2Part = i < v2Parts.length ? Integer.parseInt(v2Parts[i]) : 0;
            if (v1Part < v2Part) {
                return -1;
            }
            if (v1Part <= v2Part) continue;
            return 1;
        }
        return 0;
    }
}

