/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.dataservices.ExecCaller;
import com.marklogic.client.dataservices.IOEndpoint;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class BulkUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static void deleteData(DatabaseClient databaseClient, String apiPath, String retainDuration) {
        if (retainDuration == null || !retainDuration.matches("^(-?)P(?=.)((\\d*)Y)?((\\d+)M)?((\\d*)D)?(T(?=\\d)(\\d+H)?(([\\d]+)M)?(([\\d]+(?:\\.\\d+)?)S)?)?$")) {
            throw new IllegalArgumentException("retainDuration must be a duration in the format of PnYnM or PnDTnHnMnS");
        }
        ObjectNode endpointConstants = objectMapper.createObjectNode().put("batchSize", 250).put("retainDuration", retainDuration);
        BulkUtil.runExecCaller(databaseClient, apiPath, endpointConstants, "Unable to delete data, cause: ");
    }

    public static void runExecCaller(DatabaseClient databaseClient, String apiPath, ObjectNode endpointConstants, String errorPrefix) {
        try (InputStreamReader apiReader = new InputStreamReader(BulkUtil.class.getClassLoader().getResourceAsStream(apiPath));){
            ObjectNode apiNode = (ObjectNode)objectMapper.readValue((Reader)apiReader, ObjectNode.class);
            ExecCaller caller = ExecCaller.on((DatabaseClient)databaseClient, (JSONWriteHandle)new JacksonHandle((JsonNode)apiNode));
            CapturingErrorListener errorListener = new CapturingErrorListener();
            ExecCaller.BulkExecCaller bulkCaller = caller.bulkCaller(caller.newCallContext().withEndpointConstantsAs((Object)endpointConstants));
            bulkCaller.setErrorListener((ExecCaller.BulkExecCaller.ErrorListener)errorListener);
            bulkCaller.awaitCompletion();
            Throwable throwable = errorListener.throwable;
            if (throwable != null) {
                throw new RuntimeException(errorPrefix + throwable.getMessage(), throwable);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find API module " + apiPath + " on classpath; cause: " + e.getMessage(), e);
        }
    }

    static class CapturingErrorListener
    implements ExecCaller.BulkExecCaller.ErrorListener {
        Throwable throwable;

        CapturingErrorListener() {
        }

        public IOEndpoint.BulkIOEndpointCaller.ErrorDisposition processError(int retryCount, Throwable throwable, IOEndpoint.CallContext callContext) {
            this.throwable = throwable;
            return IOEndpoint.BulkIOEndpointCaller.ErrorDisposition.STOP_ALL_CALLS;
        }
    }
}

