/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;

public interface GraphService {
    public static GraphService on(DatabaseClient db) {
        return GraphService.on(db, null);
    }

    public static GraphService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class GraphServiceImpl
        implements GraphService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_searchNodes;
            private BaseProxy.DBFunctionRequest req_nodeExpand;

            GraphServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/5/data-services/graph/", servDecl);
                this.req_searchNodes = this.baseProxy.request("searchNodes.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
                this.req_nodeExpand = this.baseProxy.request("nodeExpand.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
            }

            @Override
            public JsonNode searchNodes(JsonNode searchQuery, String structuredQuery, String queryOptions) {
                return this.searchNodes(this.req_searchNodes.on(this.dbClient), searchQuery, structuredQuery, queryOptions);
            }

            private JsonNode searchNodes(BaseProxy.DBFunctionRequest request, JsonNode searchQuery, String structuredQuery, String queryOptions) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"query", (boolean)true, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)searchQuery.get("query"))), BaseProxy.atomicParam((String)"start", (boolean)true, (String)BaseProxy.StringType.fromString((String)searchQuery.get("start").toString())), BaseProxy.atomicParam((String)"pageLength", (boolean)true, (String)BaseProxy.StringType.fromString((String)searchQuery.get("pageLength").toString())), BaseProxy.atomicParam((String)"structuredQuery", (boolean)true, (String)BaseProxy.StringType.fromString((String)structuredQuery)), BaseProxy.atomicParam((String)"queryOptions", (boolean)true, (String)BaseProxy.StringType.fromString((String)queryOptions))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode nodeExpand(JsonNode nodeInfo, Integer limit) {
                return this.nodeExpand(this.req_nodeExpand.on(this.dbClient), nodeInfo, limit);
            }

            private JsonNode nodeExpand(BaseProxy.DBFunctionRequest request, JsonNode nodeInfo, Integer limit) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"nodeInfo", (boolean)true, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)nodeInfo)), BaseProxy.atomicParam((String)"limit", (boolean)true, (String)BaseProxy.IntegerType.fromInteger((Integer)limit))}).responseSingle(false, Format.JSON));
            }
        }
        return new GraphServiceImpl(db, serviceDeclaration);
    }

    public JsonNode searchNodes(JsonNode var1, String var2, String var3);

    public JsonNode nodeExpand(JsonNode var1, Integer var2);
}

