/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.util.stream.Stream;

public interface StepService {
    public static StepService on(DatabaseClient db) {
        return StepService.on(db, null);
    }

    public static StepService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class StepServiceImpl
        implements StepService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_getStepsByType;
            private BaseProxy.DBFunctionRequest req_saveStep;
            private BaseProxy.DBFunctionRequest req_deleteStep;
            private BaseProxy.DBFunctionRequest req_getStep;

            StepServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/5/data-services/step/", servDecl);
                this.req_getStepsByType = this.baseProxy.request("getStepsByType.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_saveStep = this.baseProxy.request("saveStep.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
                this.req_deleteStep = this.baseProxy.request("deleteStep.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_getStep = this.baseProxy.request("getStep.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
            }

            @Override
            public JsonNode getStepsByType(Stream<String> propertiesToReturn) {
                return this.getStepsByType(this.req_getStepsByType.on(this.dbClient), propertiesToReturn);
            }

            private JsonNode getStepsByType(BaseProxy.DBFunctionRequest request, Stream<String> propertiesToReturn) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"propertiesToReturn", (boolean)true, (Stream)BaseProxy.StringType.fromString(propertiesToReturn))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode saveStep(String stepDefinitionType, JsonNode stepProperties, Boolean overwrite, Boolean throwErrorIfStepIsPresent) {
                return this.saveStep(this.req_saveStep.on(this.dbClient), stepDefinitionType, stepProperties, overwrite, throwErrorIfStepIsPresent);
            }

            private JsonNode saveStep(BaseProxy.DBFunctionRequest request, String stepDefinitionType, JsonNode stepProperties, Boolean overwrite, Boolean throwErrorIfStepIsPresent) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"stepDefinitionType", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepDefinitionType)), BaseProxy.documentParam((String)"stepProperties", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)stepProperties)), BaseProxy.atomicParam((String)"overwrite", (boolean)false, (String)BaseProxy.BooleanType.fromBoolean((Boolean)overwrite)), BaseProxy.atomicParam((String)"throwErrorIfStepIsPresent", (boolean)false, (String)BaseProxy.BooleanType.fromBoolean((Boolean)throwErrorIfStepIsPresent))}).responseSingle(false, Format.JSON));
            }

            @Override
            public void deleteStep(String stepDefinitionType, String stepName) {
                this.deleteStep(this.req_deleteStep.on(this.dbClient), stepDefinitionType, stepName);
            }

            private void deleteStep(BaseProxy.DBFunctionRequest request, String stepDefinitionType, String stepName) {
                request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"stepDefinitionType", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepDefinitionType)), BaseProxy.atomicParam((String)"stepName", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepName))}).responseNone();
            }

            @Override
            public JsonNode getStep(String stepDefinitionType, String stepName) {
                return this.getStep(this.req_getStep.on(this.dbClient), stepDefinitionType, stepName);
            }

            private JsonNode getStep(BaseProxy.DBFunctionRequest request, String stepDefinitionType, String stepName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"stepDefinitionType", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepDefinitionType)), BaseProxy.atomicParam((String)"stepName", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepName))}).responseSingle(false, Format.JSON));
            }
        }
        return new StepServiceImpl(db, serviceDeclaration);
    }

    public JsonNode getStepsByType(Stream<String> var1);

    public JsonNode saveStep(String var1, JsonNode var2, Boolean var3, Boolean var4);

    public void deleteStep(String var1, String var2);

    public JsonNode getStep(String var1, String var2);
}

