/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.security.DeployAmpsCommand;
import com.marklogic.hub.MarkLogicVersion;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.AmpManager;
import java.io.File;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;

public class DeployHubAmpsCommand
extends DeployAmpsCommand {
    public DeployHubAmpsCommand() {
        this.setExecuteSortOrder(390);
    }

    public boolean cmaShouldBeUsed(CommandContext context) {
        return false;
    }

    public void execute(CommandContext context) {
        for (File resourceDir : this.getResourceDirs(context)) {
            this.processExecuteOnResourceDir(context, resourceDir);
        }
    }

    protected ResourceManager getResourceManager(CommandContext context) {
        return new HubAmpManager(context.getManageClient());
    }

    class HubAmpManager
    extends AmpManager {
        public HubAmpManager(ManageClient client) {
            super(client);
        }

        protected String getResourceName() {
            return "amp";
        }

        public SaveReceipt updateResource(String payload, String resourceId) {
            SaveReceipt receipt = null;
            try {
                receipt = super.updateResource(payload, resourceId);
            }
            catch (HttpClientErrorException ex) {
                if (HttpStatus.FORBIDDEN.equals((Object)ex.getStatusCode()) && this.cannotUpdateAmps()) {
                    this.logger.error("An error occurred while trying to update an amp: " + ex.getMessage() + ". Updates to amps as a user with the data-hub-security-admin role are not allowed in this version of MarkLogic, so this error is being logged and not thrown. If you need to modify the amp, you must delete it first via the Manage API.");
                }
                throw ex;
            }
            return receipt;
        }

        private boolean cannotUpdateAmps() {
            try {
                return new MarkLogicVersion(this.getManageClient()).cannotUpdateAmps();
            }
            catch (Exception e) {
                this.logger.warn("Could not determine MarkLogic version; cause: " + e.getMessage() + "; will assume that user can update amps and will throw original exception");
                return false;
            }
        }
    }
}

