/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.ApplyTransformListener;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.dataservices.MappingService;
import com.marklogic.hub.deploy.commands.LoadUserModulesCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GenerateFunctionMetadataCommand
extends AbstractCommand {
    @Autowired
    private HubConfig hubConfig;
    private static final String DH_FUNCTION_MODULE_PATH = "/data-hub/5/mapping-functions/";
    private static final String USER_FUNCTION_MODULE_PATH = "/custom-modules/mapping-functions/";
    private boolean catchExceptionsForUserModules = false;

    public GenerateFunctionMetadataCommand() {
        this.setExecuteSortOrder(new LoadUserModulesCommand().getExecuteSortOrder() + 1);
    }

    public GenerateFunctionMetadataCommand(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
    }

    public void execute(CommandContext context) {
        this.generateFunctionMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateFunctionMetadata() {
        DatabaseClient modulesClient = this.hubConfig.newStagingClient(this.hubConfig.getDbName(DatabaseKind.MODULES));
        DataMovementManager dataMovementManager = modulesClient.newDataMovementManager();
        ArrayList caughtExceptions = new ArrayList();
        ApplyTransformListener transformListener = new ApplyTransformListener().withTransform(new ServerTransform("mlGenerateFunctionMetadata")).withApplyResult(ApplyTransformListener.ApplyResult.IGNORE).onFailure((batch, throwable) -> {
            String moduleUri;
            boolean throwException = true;
            if (this.catchExceptionsForUserModules && ((String[])batch.getItems()).length > 0 && (moduleUri = ((String[])batch.getItems())[0]) != null && moduleUri.startsWith(USER_FUNCTION_MODULE_PATH)) {
                this.logger.info("Caught error while generating function metadata for user module: " + throwable.getMessage() + "; will not rethrow this as the user is expected to fix this themselves and then regenerate function metadata once the error is resolved.");
                throwException = false;
            }
            if (throwException) {
                this.logger.error("Caught error while generating function metadata: " + throwable.getMessage());
                caughtExceptions.add(throwable);
            }
        });
        QueryBatcher queryBatcher = dataMovementManager.newQueryBatcher(modulesClient.newQueryManager().newStructuredQueryBuilder().directory(true, new String[]{DH_FUNCTION_MODULE_PATH, USER_FUNCTION_MODULE_PATH})).withBatchSize(1).withThreadCount(4).onUrisReady(batch -> this.logger.info("Processing: " + Arrays.asList(batch.getItems()))).onUrisReady((QueryBatchListener)transformListener);
        dataMovementManager.startJob(queryBatcher);
        try {
            queryBatcher.awaitCompletion(2L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.logger.error("Loading function metadata timed out, took longer than 2 minutes");
        }
        dataMovementManager.stopJob((Batcher)queryBatcher);
        DatabaseClient stagingClient = this.hubConfig.newStagingClient(null);
        try {
            MappingService.on(stagingClient).generateMappingTransforms();
        }
        finally {
            stagingClient.release();
        }
        if (!caughtExceptions.isEmpty()) {
            throw new RuntimeException((Throwable)caughtExceptions.get(0));
        }
    }

    public void setHubConfig(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    public void setCatchExceptionsForUserModules(boolean catchExceptionsForUserModules) {
        this.catchExceptionsForUserModules = catchExceptionsForUserModules;
    }

    public boolean isCatchExceptionsForUserModules() {
        return this.catchExceptionsForUserModules;
    }
}

