/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.command.databases.DeployDatabaseCommand;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommandFactory;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.deploy.commands.DeployHubDatabaseCommand;
import java.io.File;

public class HubDeployDatabaseCommandFactory
implements DeployDatabaseCommandFactory {
    private HubConfig hubConfig;
    private boolean mergeEntityConfigFiles = true;
    private boolean mergeExistingArrayProperties = false;
    private boolean removeSchemaAndTriggersDatabaseSettings = false;

    public HubDeployDatabaseCommandFactory(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    public DeployDatabaseCommand newDeployDatabaseCommand(File databaseFile) {
        String filename = databaseFile != null ? databaseFile.getName() : null;
        DeployHubDatabaseCommand c = new DeployHubDatabaseCommand(this.hubConfig, databaseFile, filename);
        c.setDeployDatabaseCommandFactory(this);
        c.setMergeEntityConfigFiles(this.mergeEntityConfigFiles);
        c.setRemoveSchemaAndTriggersDatabaseSettings(this.removeSchemaAndTriggersDatabaseSettings);
        c.setMergeExistingArrayProperties(this.mergeExistingArrayProperties);
        return c;
    }

    public void setMergeEntityConfigFiles(boolean mergeEntityConfigFiles) {
        this.mergeEntityConfigFiles = mergeEntityConfigFiles;
    }

    public void setRemoveSchemaAndTriggersDatabaseSettings(boolean removeSchemaAndTriggersDatabaseSettings) {
        this.removeSchemaAndTriggersDatabaseSettings = removeSchemaAndTriggersDatabaseSettings;
    }

    public void setMergeExistingArrayProperties(boolean mergeExistingArrayProperties) {
        this.mergeExistingArrayProperties = mergeExistingArrayProperties;
    }
}

