/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.JSONDocumentManager;
import com.marklogic.client.ext.modulesloader.Modules;
import com.marklogic.client.ext.modulesloader.ModulesFinder;
import com.marklogic.client.ext.modulesloader.impl.EntityDefModulesFinder;
import com.marklogic.client.ext.modulesloader.impl.MappingDefModulesFinder;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import com.marklogic.client.ext.util.DefaultDocumentPermissionsParser;
import com.marklogic.client.ext.util.DocumentPermissionsParser;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.dataservices.ArtifactService;
import com.marklogic.hub.dataservices.ModelsService;
import com.marklogic.hub.dataservices.StepService;
import com.marklogic.hub.deploy.commands.LoadHubArtifactsCommand;
import com.marklogic.mgmt.resource.hosts.HostManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class LoadUserArtifactsCommand
extends AbstractCommand {
    @Autowired
    private HubConfig hubConfig;
    private DocumentPermissionsParser documentPermissionsParser = new DefaultDocumentPermissionsParser();
    private ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
    private TokenReplacer tokenReplacer;

    public LoadUserArtifactsCommand() {
        this.setExecuteSortOrder(LoadHubArtifactsCommand.SORT_ORDER + 1);
    }

    public LoadUserArtifactsCommand(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
    }

    boolean isArtifactDir(Path dir, Path startPath) {
        String dirStr = dir.toString();
        String startPathStr = Pattern.quote(startPath.toString());
        String regex = startPathStr + "[/\\\\][^/\\\\]+$";
        return dirStr.matches(regex);
    }

    public void execute(CommandContext context) {
        this.tokenReplacer = context.getAppConfig().buildTokenReplacer();
        this.loadUserArtifacts();
    }

    public void loadUserArtifacts() {
        HubClient hubClient = this.hubConfig.newHubClient();
        try {
            long start = System.currentTimeMillis();
            this.loadModels(hubClient);
            this.logger.info("Loaded models, time: " + (System.currentTimeMillis() - start) + "ms");
            start = System.currentTimeMillis();
            this.loadLegacyMappings(hubClient);
            this.loadFlows(hubClient);
            this.loadStepDefinitions(hubClient);
            this.loadSteps(hubClient);
            this.logger.info("Loaded flows, mappings, step definitions and steps, time: " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load user artifacts, cause: " + e.getMessage(), e);
        }
    }

    private void loadModels(HubClient hubClient) throws IOException {
        File modelsDir = this.hubConfig.getHubEntitiesDir().toFile();
        EntityDefModulesFinder modulesFinder = new EntityDefModulesFinder();
        this.logger.info("Loading models from directory " + modelsDir);
        ArrayNode modelsArray = this.objectMapper.createArrayNode();
        modulesFinder.findModules(modelsDir.toString()).getAssets().forEach(r -> {
            try {
                this.logger.info("Loading model from file: " + r.getFilename());
                modelsArray.add(this.readArtifact(r.getFile()));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read model file: " + r.getFilename() + "; cause: " + e.getMessage(), e);
            }
        });
        if (modelsArray.size() > 0) {
            ModelsService.on(hubClient.getStagingClient()).saveModels((JsonNode)modelsArray);
            this.clearExpandedTreeCache(hubClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExpandedTreeCache(HubClient hubClient) {
        AppConfig mlAppConfig = this.hubConfig.getAppConfig();
        String originalHost = mlAppConfig.getHost();
        try {
            new HostManager(hubClient.getManageClient()).getHostNames().forEach(host -> {
                mlAppConfig.setHost(host);
                this.logger.info("Clearing expanded tree cache on host: " + host);
                mlAppConfig.newAppServicesDatabaseClient("Documents").newServerEval().xquery("xdmp:expanded-tree-cache-clear()").evalAs(String.class);
            });
        }
        catch (Exception e) {
            this.logger.info("Failed to clear expanded tree cache: " + e.getMessage());
        }
        finally {
            mlAppConfig.setHost(originalHost);
        }
    }

    private void loadLegacyMappings(HubClient hubClient) throws IOException {
        final Path mappingsPath = this.hubConfig.getHubMappingsDir();
        if (mappingsPath.toFile().exists()) {
            JSONDocumentManager finalDocMgr = hubClient.getFinalClient().newJSONDocumentManager();
            JSONDocumentManager stagingDocMgr = hubClient.getStagingClient().newJSONDocumentManager();
            final DocumentWriteSet stagingMappingDocumentWriteSet = stagingDocMgr.newWriteSet();
            final DocumentWriteSet finalMappingDocumentWriteSet = finalDocMgr.newWriteSet();
            final ResourceToURI mappingResourceToURI = new ResourceToURI(){

                @Override
                public String toURI(Resource r) throws IOException {
                    return "/mappings/" + r.getFile().getParentFile().getName() + "/" + r.getFilename();
                }
            };
            final MappingDefModulesFinder mappingDefModulesFinder = new MappingDefModulesFinder();
            Files.walkFileTree(mappingsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (LoadUserArtifactsCommand.this.isArtifactDir(dir, mappingsPath.toAbsolutePath())) {
                        LoadUserArtifactsCommand.this.executeWalk(dir, (ModulesFinder)mappingDefModulesFinder, mappingResourceToURI, LoadUserArtifactsCommand.this.buildMetadata(LoadUserArtifactsCommand.this.hubConfig.getMappingPermissions(), "http://marklogic.com/data-hub/mappings"), new DocumentWriteSet[]{stagingMappingDocumentWriteSet, finalMappingDocumentWriteSet});
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (stagingMappingDocumentWriteSet.size() > 0) {
                stagingDocMgr.write(stagingMappingDocumentWriteSet);
                finalDocMgr.write(finalMappingDocumentWriteSet);
            }
        }
    }

    private void executeWalk(Path dir, ModulesFinder modulesFinder, ResourceToURI resourceToURI, DocumentMetadataHandle metadata, DocumentWriteSet ... writeSets) throws IOException {
        Modules modules = modulesFinder.findModules(dir.toString());
        for (Resource r : modules.getAssets()) {
            this.addResourceToWriteSets(r, resourceToURI.toURI(r), metadata, writeSets);
        }
    }

    protected DocumentMetadataHandle buildMetadata(String permissions, String collection) {
        DocumentMetadataHandle meta = new DocumentMetadataHandle();
        meta.getCollections().add((Object)collection);
        this.documentPermissionsParser.parsePermissions(permissions, meta.getPermissions());
        return meta;
    }

    private void addResourceToWriteSets(Resource r, String docId, DocumentMetadataHandle meta, DocumentWriteSet ... writeSets) throws IOException {
        JsonNode json = this.readArtifact(r.getFile());
        if (json instanceof ObjectNode && json.has("language")) {
            json = this.replaceLanguageWithLang((ObjectNode)json);
            try {
                this.objectMapper.writeValue(r.getFile(), (Object)json);
            }
            catch (Exception ex) {
                this.logger.warn("Unable to replace 'language' with 'lang' in artifact file: " + r.getFile().getAbsolutePath() + ". You should replace 'language' with 'lang' yourself in this file. Error cause: " + ex.getMessage(), (Throwable)ex);
            }
        }
        for (DocumentWriteSet writeSet : writeSets) {
            writeSet.add(docId, (DocumentMetadataWriteHandle)meta, (AbstractWriteHandle)new JacksonHandle(json));
        }
    }

    private void loadSteps(HubClient hubClient) {
        Path stepsPath = this.hubConfig.getHubProject().getStepsPath();
        if (stepsPath.toFile().exists()) {
            StepService stepService = StepService.on(hubClient.getStagingClient());
            for (File stepTypeDir : stepsPath.toFile().listFiles(File::isDirectory)) {
                String stepType = stepTypeDir.getName();
                for (File stepFile : stepTypeDir.listFiles((d, name) -> name.endsWith(".step.json"))) {
                    JsonNode step = this.readArtifact(stepFile);
                    if (!step.has("name")) {
                        throw new RuntimeException("Unable to load step from file: " + stepFile + "; no 'name' property found");
                    }
                    String stepName = step.get("name").asText();
                    this.logger.info(this.format("Loading step of type '%s' with name '%s'", new Object[]{stepType, stepName}));
                    stepService.saveStep(stepType, step, true, false);
                }
            }
        }
    }

    private void loadFlows(HubClient hubClient) {
        Path flowsPath = this.hubConfig.getHubProject().getFlowsDir();
        if (flowsPath.toFile().exists()) {
            ArtifactService service = ArtifactService.on(hubClient.getStagingClient());
            for (File file : flowsPath.toFile().listFiles(f -> f.isFile() && f.getName().endsWith(".flow.json"))) {
                JsonNode flow = this.readArtifact(file);
                if (!flow.has("name")) {
                    throw new RuntimeException("Unable to load flow from file: " + file + "; no 'name' property found");
                }
                String flowName = flow.get("name").asText();
                this.logger.info(this.format("Loading flow with name '%s'", new Object[]{flowName}));
                service.setArtifact("flow", flowName, flow, "");
            }
        }
    }

    private void loadStepDefinitions(HubClient hubClient) {
        Path stepDefsPath = this.hubConfig.getHubProject().getStepDefinitionsDir();
        if (stepDefsPath.toFile().exists()) {
            ArtifactService service = ArtifactService.on(hubClient.getStagingClient());
            for (File typeDir : stepDefsPath.toFile().listFiles(File::isDirectory)) {
                String stepDefType = typeDir.getName();
                for (File defDir : typeDir.listFiles(File::isDirectory)) {
                    String[] fileNames;
                    for (String stepDefFileName : fileNames = defDir.list()) {
                        File stepDefFile = new File(defDir, stepDefFileName);
                        if (stepDefFile.exists()) {
                            JsonNode stepDef = this.readArtifact(stepDefFile);
                            if (!stepDef.has("name")) {
                                throw new RuntimeException("Unable to load step definition from file: " + stepDefFile + "; no 'name' property was found");
                            }
                            String stepDefName = stepDef.get("name").asText();
                            this.logger.info(this.format("Loading step definition with type '%s' and name '%s'", new Object[]{stepDefType, stepDefName}));
                            service.setArtifact("stepDefinition", stepDefName, stepDef, stepDefFileName.replace(".step.json", ""));
                            continue;
                        }
                        this.logger.warn(this.format("Found step definition directory '%s', but did not find expected step definition file: '%s'", new Object[]{defDir.getAbsolutePath(), stepDefFile.getName()}));
                    }
                }
            }
        }
    }

    protected ObjectNode replaceLanguageWithLang(ObjectNode object) {
        ObjectNode newObject = this.objectMapper.createObjectNode();
        newObject.put("lang", object.get("language").asText());
        Iterator fieldNames = object.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if ("language".equals(fieldName)) continue;
            newObject.set(fieldName, object.get(fieldName));
        }
        return newObject;
    }

    private JsonNode readArtifact(File file) {
        JsonNode jsonNode;
        try {
            String artifact = this.tokenReplacer.replaceTokens(FileUtils.readFileToString((File)file));
            jsonNode = this.objectMapper.readTree(artifact);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read file " + file.getName() + " + as JSON; cause: " + e.getMessage(), e);
        }
        return jsonNode;
    }

    public void setHubConfig(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    abstract class ResourceToURI {
        ResourceToURI() {
        }

        public abstract String toURI(Resource var1) throws IOException;
    }
}

