/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.modules.AllButAssetsModulesFinder;
import com.marklogic.appdeployer.command.modules.LoadModulesCommand;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.XMLDocumentManager;
import com.marklogic.client.ext.file.CacheBusterDocumentFileProcessor;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.modulesloader.ModulesFinder;
import com.marklogic.client.ext.modulesloader.ModulesManager;
import com.marklogic.client.ext.modulesloader.impl.AssetFileLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesLoader;
import com.marklogic.client.ext.modulesloader.impl.PropertiesModuleManager;
import com.marklogic.client.ext.modulesloader.impl.SearchOptionsFinder;
import com.marklogic.client.ext.modulesloader.impl.UserModulesFinder;
import com.marklogic.client.ext.util.DefaultDocumentPermissionsParser;
import com.marklogic.client.ext.util.DocumentPermissionsParser;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.hub.EntityManager;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.deploy.util.HubFileFilter;
import com.marklogic.hub.impl.EntityManagerImpl;
import com.marklogic.hub.legacy.LegacyFlowManager;
import com.marklogic.hub.legacy.flow.LegacyFlow;
import com.marklogic.hub.legacy.impl.LegacyFlowManagerImpl;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class LoadUserModulesCommand
extends LoadModulesCommand {
    @Autowired
    private HubConfig hubConfig;
    @Autowired
    protected EntityManager entityManager;
    @Autowired
    private LegacyFlowManager legacyFlowManager;
    private DocumentPermissionsParser documentPermissionsParser = new DefaultDocumentPermissionsParser();
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private boolean loadQueryOptions = true;
    private boolean loadAllModules = true;
    private boolean forceLoad = false;

    public void setForceLoad(boolean forceLoad) {
        this.forceLoad = forceLoad;
    }

    public LoadUserModulesCommand() {
        this.setExecuteSortOrder(460);
    }

    public LoadUserModulesCommand(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
        this.entityManager = new EntityManagerImpl(hubConfig);
        this.legacyFlowManager = new LegacyFlowManagerImpl(hubConfig);
    }

    private PropertiesModuleManager getModulesManager() {
        String hubUserTimestampFilePath = this.hubConfig.getHubProject().getUserModulesDeployTimestampFile();
        String appConfigTimestampFilePath = this.hubConfig.getAppConfig().getModuleTimestampsPath();
        PropertiesModuleManager pmm = new PropertiesModuleManager(hubUserTimestampFilePath);
        this.logger.info("Initializing PropertiesModuleManager with properties timestamp file: " + hubUserTimestampFilePath);
        if (this.forceLoad) {
            File defaultTimestampFile;
            this.logger.info("Deleting properties timestamp file as part of force load: " + hubUserTimestampFilePath);
            pmm.deletePropertiesFile();
            if (appConfigTimestampFilePath != null && (defaultTimestampFile = new File(appConfigTimestampFilePath)).exists()) {
                defaultTimestampFile.delete();
            }
        }
        pmm.initialize();
        return pmm;
    }

    private AssetFileLoader getAssetFileLoader(AppConfig config, PropertiesModuleManager moduleManager) {
        AssetFileLoader assetFileLoader = new AssetFileLoader(this.hubConfig.newModulesDbClient(), (ModulesManager)moduleManager);
        assetFileLoader.addDocumentFileProcessor((DocumentFileProcessor)new CacheBusterDocumentFileProcessor());
        assetFileLoader.addFileFilter((FileFilter)new HubFileFilter());
        assetFileLoader.setPermissions(config.getModulePermissions());
        return assetFileLoader;
    }

    private DefaultModulesLoader getStagingModulesLoader(AppConfig config) {
        this.threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        this.threadPoolTaskExecutor.setCorePoolSize(16);
        this.threadPoolTaskExecutor.setAwaitTerminationSeconds(600);
        this.threadPoolTaskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        this.threadPoolTaskExecutor.afterPropertiesSet();
        PropertiesModuleManager moduleManager = this.getModulesManager();
        AssetFileLoader assetFileLoader = this.getAssetFileLoader(config, moduleManager);
        DefaultModulesLoader modulesLoader = new DefaultModulesLoader(assetFileLoader);
        modulesLoader.setModulesManager((ModulesManager)moduleManager);
        modulesLoader.setTaskExecutor((TaskExecutor)this.threadPoolTaskExecutor);
        modulesLoader.setShutdownTaskExecutorAfterLoadingModules(false);
        return modulesLoader;
    }

    boolean isInputRestDir(Path dir) {
        return dir.endsWith("REST") && dir.toString().matches(".*[/\\\\]input[/\\\\].*");
    }

    boolean isHarmonizeRestDir(Path dir) {
        return dir.endsWith("REST") && dir.toString().matches(".*[/\\\\]harmonize[/\\\\].*");
    }

    boolean isFlowPropertiesFile(Path dir) {
        Path parent = dir.getParent();
        return dir.toFile().isFile() && dir.getFileName().toString().endsWith(".properties") && parent.toString().matches(".*[/\\\\](input|harmonize)[/\\\\][^/\\\\]+$") && dir.getFileName().toString().equals(parent.getFileName().toString() + ".properties");
    }

    private void loadModulesFromStandardMlGradleLocations(CommandContext context) {
        super.execute(context);
    }

    public void execute(CommandContext context) {
        AppConfig config = context.getAppConfig();
        final DatabaseClient stagingClient = this.hubConfig.newStagingClient();
        final DatabaseClient finalClient = this.hubConfig.newFinalClient();
        Path userModulesPath = this.hubConfig.getHubPluginsDir();
        String baseDir = new String();
        String EncodedBaseDir = userModulesPath.normalize().toAbsolutePath().toString();
        Path startPath = userModulesPath.resolve("entities");
        try {
            URLDecoder fileNameDecoder = new URLDecoder();
            baseDir = URLDecoder.decode(EncodedBaseDir, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final DefaultModulesLoader modulesLoader = this.getStagingModulesLoader(config);
        if (this.loadAllModules) {
            this.loadModulesFromStandardMlGradleLocations(context);
        }
        modulesLoader.loadModules(baseDir, (ModulesFinder)new UserModulesFinder(), stagingClient);
        if (this.loadQueryOptions) {
            modulesLoader.loadModules("classpath*:/ml-modules-final", (ModulesFinder)new SearchOptionsFinder(), finalClient);
        }
        final AllButAssetsModulesFinder allButAssetsModulesFinder = new AllButAssetsModulesFinder();
        if (this.loadQueryOptions) {
            String gerProjectDir = this.hubConfig.getHubProject().getProjectDirString();
            String decodedFileName = new String();
            try {
                URLDecoder fileNameDecoder = new URLDecoder();
                decodedFileName = URLDecoder.decode(gerProjectDir, StandardCharsets.UTF_8.name());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Path entityConfigDir = Paths.get(decodedFileName, "src/main/entity-config");
            if (!entityConfigDir.toFile().exists()) {
                entityConfigDir.toFile().mkdirs();
            }
            this.entityManager.deployQueryOptions();
        }
        try {
            if (startPath.toFile().exists()) {
                XMLDocumentManager documentManager = this.hubConfig.newModulesDbClient().newXMLDocumentManager();
                final DocumentWriteSet documentWriteSet = documentManager.newWriteSet();
                DocumentMetadataHandle meta = new DocumentMetadataHandle();
                this.documentPermissionsParser.parsePermissions(this.hubConfig.getModulePermissions(), meta.getPermissions());
                documentWriteSet.addDefault((DocumentMetadataWriteHandle)meta);
                final ModulesManager modulesManager = modulesLoader.getModulesManager();
                Files.walkFileTree(startPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        String currentDir = dir.normalize().toAbsolutePath().toString();
                        if (LoadUserModulesCommand.this.isInputRestDir(dir)) {
                            modulesLoader.loadModules(currentDir, (ModulesFinder)allButAssetsModulesFinder, stagingClient);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (LoadUserModulesCommand.this.isHarmonizeRestDir(dir)) {
                            modulesLoader.loadModules(currentDir, (ModulesFinder)allButAssetsModulesFinder, finalClient);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (LoadUserModulesCommand.this.isFlowPropertiesFile(file) && modulesManager.hasFileBeenModifiedSinceLastLoaded(file.toFile())) {
                            LegacyFlow flow = LoadUserModulesCommand.this.legacyFlowManager.getFlowFromProperties(file);
                            StringHandle handle = new StringHandle(flow.serialize());
                            handle.setFormat(Format.XML);
                            documentWriteSet.add(flow.getFlowDbPath(), (AbstractWriteHandle)handle);
                            modulesManager.saveLastLoadedTimestamp(file.toFile(), new Date());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                if (documentWriteSet.size() > 0) {
                    documentManager.write(documentWriteSet);
                }
            }
            this.threadPoolTaskExecutor.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setHubConfig(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
        if (this.entityManager == null) {
            this.entityManager = new EntityManagerImpl(hubConfig);
        }
    }

    public void setLoadQueryOptions(boolean loadQueryOptions) {
        this.loadQueryOptions = loadQueryOptions;
    }

    public void setLoadAllModules(boolean loadAllModules) {
        this.loadAllModules = loadAllModules;
    }
}

