/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.entity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.hub.entity.DefinitionsType;
import com.marklogic.hub.entity.InfoType;
import com.marklogic.hub.entity.JsonPojo;

public class HubEntity
extends JsonPojo {
    protected String filename;
    protected InfoType info;
    protected DefinitionsType definitions;

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public InfoType getInfo() {
        return this.info;
    }

    public void setInfo(InfoType info) {
        this.info = info;
    }

    public DefinitionsType getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(DefinitionsType definition) {
        this.definitions = definition;
    }

    @Override
    public JsonNode toJson() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        HubEntity.writeObjectIf(node, "info", this.info);
        node.set("definitions", this.definitions.toJson());
        return node;
    }

    public static HubEntity fromJson(String filename, JsonNode node) {
        HubEntity hubEntity = new HubEntity();
        hubEntity.setFilename(filename);
        hubEntity.setInfo(InfoType.fromJson(node.get("info")));
        String title = hubEntity.getInfo().getTitle();
        hubEntity.setDefinitions(DefinitionsType.fromJson(node.get("definitions")));
        return hubEntity;
    }
}

