/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.FlowManager;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.error.DataHubProjectException;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.impl.FinalDatabaseXmlFileUpgrader;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.hub.util.FileUtil;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

public class HubProjectImpl
extends LoggingObject
implements HubProject {
    public static final String ENTITY_CONFIG_DIR = "src/main/entity-config";
    public static final String MODULES_DIR = "src/main/ml-modules";
    public static final String USER_SCHEMAS_DIR = "src/main/ml-schemas";
    private String projectDirString;
    private Path projectDir;
    private Path pluginsDir;
    private Path stepDefinitionsDir;
    private String userModulesDeployTimestampFile = "user-modules-deploy-timestamps.properties";
    private String[] artifactTypes = new String[]{"entities", "step-definitions", "steps"};

    @Override
    public String getProjectDirString() {
        return this.projectDirString;
    }

    @Override
    public void createProject(String projectDirString) {
        this.projectDirString = projectDirString;
        this.projectDir = Paths.get(projectDirString, new String[0]).toAbsolutePath();
        this.pluginsDir = this.projectDir.resolve("plugins");
        this.stepDefinitionsDir = this.projectDir.resolve("step-definitions");
    }

    @Override
    public Path getHubPluginsDir() {
        return this.pluginsDir;
    }

    @Override
    public Path getStepDefinitionsDir() {
        return this.stepDefinitionsDir;
    }

    @Override
    public Path getStepDefinitionPath(StepDefinition.StepDefinitionType type) {
        Path path;
        if (type == null) {
            throw new DataHubProjectException("Invalid Step type");
        }
        switch (type) {
            case CUSTOM: {
                path = this.stepDefinitionsDir.resolve("custom");
                break;
            }
            case INGESTION: {
                path = this.stepDefinitionsDir.resolve("ingestion");
                break;
            }
            case MAPPING: {
                path = this.stepDefinitionsDir.resolve("mapping");
                break;
            }
            case MASTERING: {
                path = this.stepDefinitionsDir.resolve("mastering");
                break;
            }
            case MATCHING: {
                path = this.stepDefinitionsDir.resolve("matching");
                break;
            }
            case MERGING: {
                path = this.stepDefinitionsDir.resolve("merging");
                break;
            }
            default: {
                throw new DataHubProjectException("Invalid Step type" + type.toString());
            }
        }
        return path;
    }

    @Override
    public Path getHubEntitiesDir() {
        return this.projectDir.resolve("entities");
    }

    @Override
    public Path getHubMappingsDir() {
        return this.projectDir.resolve("mappings");
    }

    @Override
    public Path getLegacyHubEntitiesDir() {
        return this.pluginsDir.resolve("entities");
    }

    @Override
    public Path getLegacyHubMappingsDir() {
        return this.pluginsDir.resolve("mappings");
    }

    @Override
    public Path getHubConfigDir() {
        return this.projectDir.resolve("src/main/hub-internal-config");
    }

    @Override
    public Path getHubDatabaseDir() {
        return this.getHubConfigDir().resolve("databases");
    }

    @Override
    public Path getHubServersDir() {
        return this.getHubConfigDir().resolve("servers");
    }

    @Override
    public Path getHubSecurityDir() {
        return this.getHubConfigDir().resolve("security");
    }

    @Override
    public Path getHubTriggersDir() {
        return this.getHubConfigDir().resolve("triggers");
    }

    @Override
    public Path getUserConfigDir() {
        return this.projectDir.resolve("src/main/ml-config");
    }

    @Override
    public Path getUserSecurityDir() {
        return this.getUserConfigDir().resolve("security");
    }

    @Override
    public Path getUserDatabaseDir() {
        return this.getUserConfigDir().resolve("databases");
    }

    @Override
    public Path getUserSchemasDir() {
        return this.projectDir.resolve(USER_SCHEMAS_DIR);
    }

    @Override
    public Path getUserServersDir() {
        return this.getUserConfigDir().resolve("servers");
    }

    @Override
    public Path getEntityConfigDir() {
        return this.projectDir.resolve(ENTITY_CONFIG_DIR);
    }

    @Override
    public Path getEntityDatabaseDir() {
        return this.getEntityConfigDir().resolve("databases");
    }

    @Override
    public Path getFlowsDir() {
        return this.projectDir.resolve("flows");
    }

    @Override
    @Deprecated
    public Path getHubStagingModulesDir() {
        return this.projectDir.resolve(MODULES_DIR);
    }

    @Override
    @Deprecated
    public Path getUserStagingModulesDir() {
        return this.projectDir.resolve(MODULES_DIR);
    }

    @Override
    public Path getModulesDir() {
        return this.projectDir.resolve(MODULES_DIR);
    }

    @Override
    @Deprecated
    public Path getUserFinalModulesDir() {
        return this.projectDir.resolve(MODULES_DIR);
    }

    @Override
    public Path getCustomModulesDir() {
        return this.getModulesDir().resolve("root").resolve("custom-modules");
    }

    @Override
    public Path getCustomMappingFunctionsDir() {
        return this.getCustomModulesDir().resolve("mapping-functions");
    }

    @Override
    public boolean isInitialized() {
        File buildGradle = this.projectDir.resolve("build.gradle").toFile();
        File gradleProperties = this.projectDir.resolve("gradle.properties").toFile();
        File hubConfigDir = this.getHubConfigDir().toFile();
        File userConfigDir = this.getUserConfigDir().toFile();
        File databasesDir = this.getHubDatabaseDir().toFile();
        File serversDir = this.getHubServersDir().toFile();
        File securityDir = this.getHubSecurityDir().toFile();
        boolean newConfigInitialized = hubConfigDir.exists() && hubConfigDir.isDirectory() && userConfigDir.exists() && userConfigDir.isDirectory() && databasesDir.exists() && databasesDir.isDirectory() && serversDir.exists() && serversDir.isDirectory() && securityDir.exists() && securityDir.isDirectory();
        return buildGradle.exists() && gradleProperties.exists() && newConfigInitialized;
    }

    @Override
    public void init(Map<String, String> customTokens) {
        if (customTokens == null) {
            customTokens = new HashMap<String, String>();
        }
        for (String artifactType : this.artifactTypes) {
            File artifactTypeDir = this.getProjectDir().resolve(artifactType).toFile();
            if (artifactTypeDir.exists()) continue;
            artifactTypeDir.mkdirs();
        }
        Path userModules = this.projectDir.resolve(MODULES_DIR);
        userModules.toFile().mkdirs();
        Path customModulesDir = this.getCustomModulesDir();
        customModulesDir.toFile().mkdirs();
        this.getCustomMappingFunctionsDir().toFile().mkdirs();
        for (StepDefinition.StepDefinitionType stepType : StepDefinition.StepDefinitionType.values()) {
            customModulesDir.resolve(stepType.toString().toLowerCase()).toFile().mkdirs();
        }
        Path hubServersDir = this.getHubServersDir();
        hubServersDir.toFile().mkdirs();
        this.writeResourceFile("hub-internal-config/servers/staging-server.json", hubServersDir.resolve("staging-server.json"), true);
        this.writeResourceFile("hub-internal-config/servers/job-server.json", hubServersDir.resolve("job-server.json"), true);
        Path hubDatabaseDir = this.getHubDatabaseDir();
        hubDatabaseDir.toFile().mkdirs();
        this.writeResourceFile("hub-internal-config/databases/staging-database.json", hubDatabaseDir.resolve("staging-database.json"), true);
        this.writeResourceFile("hub-internal-config/databases/job-database.json", hubDatabaseDir.resolve("job-database.json"), true);
        this.writeResourceFile("hub-internal-config/databases/staging-schemas-database.json", hubDatabaseDir.resolve("staging-schemas-database.json"), true);
        this.writeResourceFile("hub-internal-config/databases/staging-triggers-database.json", hubDatabaseDir.resolve("staging-triggers-database.json"), true);
        Path hubDatabaseFieldsDir = this.getHubConfigDir().resolve("database-fields");
        hubDatabaseFieldsDir.toFile().mkdirs();
        this.writeResourceFile("hub-internal-config/database-fields/staging-database.xml", hubDatabaseFieldsDir.resolve("staging-database.xml"), true);
        this.writeResourceFile("hub-internal-config/database-fields/job-database.xml", hubDatabaseFieldsDir.resolve("job-database.xml"), true);
        boolean overwriteUserConfigFiles = false;
        Path userServersDir = this.getUserServersDir();
        userServersDir.toFile().mkdirs();
        this.writeResourceFile("ml-config/servers/final-server.json", userServersDir.resolve("final-server.json"), false);
        Path userDatabaseDir = this.getUserDatabaseDir();
        userDatabaseDir.toFile().mkdirs();
        this.writeResourceFile("ml-config/databases/final-database.json", userDatabaseDir.resolve("final-database.json"), false);
        this.writeResourceFile("ml-config/databases/modules-database.json", userDatabaseDir.resolve("modules-database.json"), false);
        this.writeResourceFile("ml-config/databases/final-schemas-database.json", userDatabaseDir.resolve("final-schemas-database.json"), false);
        this.writeResourceFile("ml-config/databases/final-triggers-database.json", userDatabaseDir.resolve("final-triggers-database.json"), false);
        Path userDatabaseFieldsDir = this.getUserConfigDir().resolve("database-fields");
        userDatabaseFieldsDir.toFile().mkdirs();
        this.writeResourceFile("ml-config/database-fields/final-database.xml", userDatabaseFieldsDir.resolve("final-database.xml"), false);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            this.writeResources(resolver, "classpath:hub-internal-config/security/amps/*.json", this.getHubSecurityDir().resolve("amps"));
            this.writeResources(resolver, "classpath:hub-internal-config/security/privileges/*.json", this.getHubSecurityDir().resolve("privileges"));
            this.writeResources(resolver, "classpath:hub-internal-config/security/roles/*.json", this.getHubSecurityDir().resolve("roles"));
            this.writeResources(resolver, "classpath:hub-internal-config/triggers/*.json", this.getHubTriggersDir());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write project resources to project filesystem; cause: " + e.getMessage(), e);
        }
        Path userSecurityDir = this.getUserSecurityDir();
        userSecurityDir.resolve("roles").toFile().mkdirs();
        userSecurityDir.resolve("users").toFile().mkdirs();
        userSecurityDir.resolve("privileges").toFile().mkdirs();
        this.getUserServersDir().toFile().mkdirs();
        this.getUserDatabaseDir().toFile().mkdirs();
        String stagingSchemasKey = "%%mlStagingSchemasDbName%%";
        if (customTokens.containsKey("%%mlStagingSchemasDbName%%")) {
            this.getUserDatabaseDir().resolve(customTokens.get("%%mlStagingSchemasDbName%%")).resolve("schemas").toFile().mkdirs();
        }
        this.getUserSchemasDir().toFile().mkdirs();
        this.getFlowsDir().toFile().mkdirs();
        Path gradlew = this.projectDir.resolve("gradlew");
        this.writeResourceFile("scaffolding/gradlew", gradlew);
        this.makeExecutable(gradlew);
        Path gradlewbat = this.projectDir.resolve("gradlew.bat");
        this.writeResourceFile("scaffolding/gradlew.bat", gradlewbat);
        this.makeExecutable(gradlewbat);
        Path gradleWrapperDir = this.projectDir.resolve("gradle").resolve("wrapper");
        gradleWrapperDir.toFile().mkdirs();
        this.writeResourceFile("scaffolding/gradle/wrapper/gradle-wrapper.jar", gradleWrapperDir.resolve("gradle-wrapper.jar"), true);
        this.writeResourceFile("scaffolding/gradle/wrapper/gradle-wrapper.properties", gradleWrapperDir.resolve("gradle-wrapper.properties"), true);
        this.writeResourceFile("scaffolding/build_gradle", this.projectDir.resolve("build.gradle"));
        this.writeResourceFileWithReplace(customTokens, "scaffolding/gradle_properties", this.projectDir.resolve("gradle.properties"));
        this.writeResourceFile("scaffolding/gradle-local_properties", this.projectDir.resolve("gradle-local.properties"));
    }

    private void writeResources(PathMatchingResourcePatternResolver resolver, String pattern, Path projectTargetPath) throws IOException {
        projectTargetPath.toFile().mkdirs();
        for (Resource resource : resolver.getResources(pattern)) {
            FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)new FileOutputStream(projectTargetPath.resolve(resource.getFilename()).toFile()));
        }
    }

    private void makeExecutable(Path file) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        try {
            Files.setPosixFilePermissions(file, perms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeResourceFile(String srcFile, Path dstFile) {
        this.writeResourceFile(srcFile, dstFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResourceFile(String srcFile, Path dstFile, boolean overwrite) {
        if (overwrite || !dstFile.toFile().exists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Getting file: " + srcFile);
            }
            InputStream inputStream = null;
            try {
                inputStream = HubProject.class.getClassLoader().getResourceAsStream(srcFile);
                FileUtil.copy(inputStream, dstFile.toFile());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void writeResourceFileWithReplace(Map<String, String> customTokens, String srcFile, Path dstFile) {
        this.writeResourceFileWithReplace(customTokens, srcFile, dstFile, false);
    }

    private void writeResourceFileWithReplace(Map<String, String> customTokens, String srcFile, Path dstFile, boolean overwrite) {
        block18: {
            InputStream inputStream = null;
            try {
                if (!overwrite && dstFile.toFile().exists()) break block18;
                this.logger.debug("Getting file with replace: " + srcFile);
                inputStream = HubProject.class.getClassLoader().getResourceAsStream(srcFile);
                String fileContents = IOUtils.toString((InputStream)inputStream);
                for (String key : customTokens.keySet()) {
                    String value = customTokens.get(key);
                    if (value == null) continue;
                    fileContents = fileContents.replace(key, value);
                }
                try (FileWriter writer = new FileWriter(dstFile.toFile());){
                    writer.write(fileContents);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }

    @Override
    public void upgradeProject(FlowManager flowManager) throws IOException {
        File[] oldMappingsDirectories;
        File[] oldEntityDirectories;
        Path oldEntitiesDir = this.getLegacyHubEntitiesDir();
        Path oldMappingsDir = this.getLegacyHubMappingsDir();
        Path newEntitiesDirPath = this.getHubEntitiesDir();
        Path newMappingsDirPath = this.getHubMappingsDir();
        File newEntitiesDirFile = newEntitiesDirPath.toFile();
        File newMappingsDirFile = newMappingsDirPath.toFile();
        if (!newEntitiesDirFile.exists()) {
            newEntitiesDirFile.mkdir();
        }
        if (!newMappingsDirFile.exists()) {
            newMappingsDirFile.mkdir();
        }
        if ((oldEntityDirectories = oldEntitiesDir.toFile().listFiles()) != null) {
            for (File legacyEntityDir : oldEntityDirectories) {
                File[] entityFiles;
                if (!legacyEntityDir.isDirectory() || (entityFiles = legacyEntityDir.listFiles((file, name) -> name.endsWith(".entity.json"))) == null) continue;
                for (File entityFile : entityFiles) {
                    this.logger.info("Moving plugins/entities/" + legacyEntityDir.getName() + "/" + entityFile.getName() + " to entities/" + entityFile.getName());
                    Files.move(entityFile.toPath(), newEntitiesDirPath.resolve(entityFile.getName()), new CopyOption[0]);
                }
            }
        }
        if ((oldMappingsDirectories = oldMappingsDir.toFile().listFiles()) != null) {
            for (File legacyMappingsDir : oldMappingsDirectories) {
                File[] mappingsFiles;
                if (!legacyMappingsDir.isDirectory()) continue;
                if (!newMappingsDirPath.resolve(legacyMappingsDir.getName()).toFile().exists()) {
                    newMappingsDirPath.resolve(legacyMappingsDir.getName()).toFile().mkdir();
                }
                if ((mappingsFiles = legacyMappingsDir.listFiles((file, name) -> name.endsWith(".mapping.json"))) == null) continue;
                for (File mappingsFile : mappingsFiles) {
                    this.logger.info("Moving plugins/mappings/" + legacyMappingsDir.getName() + "/" + mappingsFile.getName() + " to mappings/" + legacyMappingsDir.getName() + "/" + mappingsFile.getName());
                    Files.move(mappingsFile.toPath(), newMappingsDirPath.resolve(legacyMappingsDir.getName()).resolve(mappingsFile.getName()), new CopyOption[0]);
                }
            }
        }
        this.removeEmptyRangeElementIndexArrayFromFinalDatabaseFile();
        this.upgradeFinalDatabaseXmlFile();
        this.updateStepDefinitionTypeForInlineMappingSteps(flowManager);
    }

    private void upgradeFinalDatabaseXmlFile() {
        File finalDbFile = this.getUserConfigDir().resolve("database-fields").resolve("final-database.xml").toFile();
        try {
            String fileContents = new String(FileCopyUtils.copyToByteArray((File)finalDbFile));
            String upgradedFileContents = new FinalDatabaseXmlFileUpgrader().updateFinalDatabaseXmlFile(fileContents);
            FileCopyUtils.copy((byte[])upgradedFileContents.getBytes(), (File)finalDbFile);
        }
        catch (Exception e) {
            throw new DataHubProjectException("Error while upgrading project; was not able to add /matchSummary/actionDetails/*/uris path range index to final-database.xml file; cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void exportProject(File location) {
        if (!location.getParentFile().exists()) {
            location.getParentFile().mkdirs();
        }
        try (FileOutputStream out = new FileOutputStream(location);){
            this.exportProject(out, new ArrayList<String>());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to export project, cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void exportProject(OutputStream outputStream) {
        this.exportProject(outputStream, new ArrayList<String>());
    }

    public void exportProject(OutputStream outputStream, List<String> additionalFilesTobeAdded) {
        Stream<String> filesToBeAddedToZip = Stream.of("entities", "flows", "src/main", "step-definitions", "steps", "gradle", "gradlew", "gradlew.bat", "build.gradle", "gradle.properties");
        if (additionalFilesTobeAdded.isEmpty()) {
            this.writeToStream(outputStream, filesToBeAddedToZip);
        } else {
            this.writeToStream(outputStream, Stream.concat(filesToBeAddedToZip, additionalFilesTobeAdded.stream()));
        }
    }

    private void writeToStream(OutputStream out, Stream<String> filesToBeAddedToZip) {
        try (ZipOutputStream zout = new ZipOutputStream(out);){
            filesToBeAddedToZip.forEach(file -> {
                File fileToZip = this.getProjectDir().resolve((String)file).toFile();
                if (!fileToZip.exists()) {
                    this.logger.warn(String.format("%s does not exist during project export.", fileToZip.toString()));
                    return;
                }
                try {
                    if (fileToZip.isDirectory()) {
                        zout.putNextEntry(new ZipEntry(file + "/"));
                        this.zipSubDirectory(file + "/", fileToZip, zout);
                    } else {
                        this.zipSubDirectory("", fileToZip, zout);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to export project, cause: " + ex.getMessage(), ex);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to export project, cause: " + e.getMessage(), e);
        }
    }

    @Override
    public String getProjectName() {
        return this.getProjectDir().toFile().getName();
    }

    private void zipSubDirectory(String basePath, File fileToZip, ZipOutputStream zout) throws IOException {
        File[] files = fileToZip.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    String path = basePath + file.getName() + "/";
                    zout.putNextEntry(new ZipEntry(path));
                    this.zipSubDirectory(path, file, zout);
                    continue;
                }
                this.addFileToZip(basePath, file, zout);
            }
        } else {
            this.addFileToZip(basePath, fileToZip, zout);
        }
    }

    private void addFileToZip(String basePath, File fileToZip, ZipOutputStream zout) throws IOException {
        FileInputStream fin = new FileInputStream(fileToZip);
        zout.putNextEntry(new ZipEntry(basePath + fileToZip.getName()));
        IOUtils.copy((InputStream)fin, (OutputStream)zout);
        IOUtils.closeQuietly((InputStream)fin);
    }

    protected void updateStepDefinitionTypeForInlineMappingSteps(FlowManager flowManager) {
        try {
            flowManager.getLocalFlows().forEach(flow -> {
                AtomicBoolean shouldSaveFlow = new AtomicBoolean(false);
                flow.getSteps().values().forEach(step -> {
                    if (StepDefinition.StepDefinitionType.MAPPING.equals((Object)step.getStepDefinitionType()) && "default-mapping".equalsIgnoreCase(step.getStepDefinitionName())) {
                        step.setStepDefinitionName("entity-services-mapping");
                        shouldSaveFlow.set(true);
                    }
                });
                if (shouldSaveFlow.get()) {
                    flowManager.saveLocalFlow((Flow)flow);
                }
            });
        }
        catch (Exception ex) {
            this.logger.warn("Error occurred while attempting to upgrade mapping steps to use 'entity-services-mapping' stepDefinitionType instead of 'default-mapping'; error: " + ex.getMessage());
            this.logger.warn("If you have any steps in flows with a stepDefinitionType of 'default-mapping', please change these to be 'entity-services-mapping' instead, as this is the preferred type for mapping steps as of DHF 5.1.0.");
        }
    }

    protected void removeEmptyRangeElementIndexArrayFromFinalDatabaseFile() {
        File dbFile = this.getUserConfigDir().resolve("databases").resolve("final-database.json").toFile();
        if (dbFile != null && dbFile.exists()) {
            try {
                ObjectNode db = (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(dbFile);
                if (this.hasEmptyRangeElementIndexArray(db)) {
                    this.logger.warn("Removing empty range-element-index array from final-database.json to avoid unnecessary reindexing");
                    db.remove("range-element-index");
                    ObjectMapperFactory.getObjectMapper().writeValue(dbFile, (Object)db);
                }
            }
            catch (Exception ex) {
                this.logger.warn("Unable to determine if final-database.json file has a range-element-index field with an empty array as its value; if it does, please remove this to avoid unnecessary reindexing; exception: " + ex.getMessage());
            }
        }
    }

    protected boolean hasEmptyRangeElementIndexArray(ObjectNode db) {
        ArrayNode indexes;
        JsonNode node;
        return db.has("range-element-index") && (node = db.get("range-element-index")) instanceof ArrayNode && (indexes = (ArrayNode)node).size() == 0;
    }

    @Override
    public String getUserModulesDeployTimestampFile() {
        Path timestampPath = Paths.get(this.projectDirString, ".tmp", this.userModulesDeployTimestampFile);
        File parentFile = timestampPath.getParent().toFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return timestampPath.toString();
    }

    @Override
    public void setUserModulesDeployTimestampFile(String userModulesDeployTimestampFile) {
        this.userModulesDeployTimestampFile = userModulesDeployTimestampFile;
    }

    @Override
    @Deprecated
    public Path getEntityDir(String entityName) {
        return this.getLegacyHubEntitiesDir().resolve(entityName);
    }

    @Override
    public Path getMappingDir(String mappingName) {
        return this.getHubMappingsDir().resolve(mappingName);
    }

    @Override
    public Path getLegacyMappingDir(String mappingName) {
        return this.getLegacyHubMappingsDir().resolve(mappingName);
    }

    @Override
    public Path getCustomModuleDir(String stepName, String stepType) {
        return this.getCustomModulesDir().resolve(stepType).resolve(stepName);
    }

    @Override
    public Path getProjectDir() {
        return this.projectDir;
    }

    @Override
    public Path getStepsPath() {
        return this.projectDir.resolve("steps");
    }

    @Override
    public Path getStepsPath(StepDefinition.StepDefinitionType type) {
        Path path;
        Path parent = this.getStepsPath();
        if (type == null) {
            throw new DataHubProjectException("Invalid Step type");
        }
        switch (type) {
            case CUSTOM: {
                path = parent.resolve("custom");
                break;
            }
            case INGESTION: {
                path = parent.resolve("ingestion");
                break;
            }
            case MAPPING: {
                path = parent.resolve("mapping");
                break;
            }
            case MASTERING: {
                path = parent.resolve("mastering");
                break;
            }
            case MATCHING: {
                path = parent.resolve("matching");
                break;
            }
            case MERGING: {
                path = parent.resolve("merging");
                break;
            }
            default: {
                throw new DataHubProjectException("Invalid Step type" + type.toString());
            }
        }
        return path;
    }

    @Override
    public File getStepFile(StepDefinition.StepDefinitionType stepType, String stepName) {
        return this.getStepsPath().resolve(stepType.toString()).resolve(stepName + ".step.json").toFile();
    }
}

