/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.StepDefinitionManager;
import com.marklogic.hub.dataservices.ArtifactService;
import com.marklogic.hub.error.DataHubProjectException;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.hub.step.StepDefinitionProvider;
import com.marklogic.hub.util.FileUtil;
import com.marklogic.hub.util.json.JSONObject;
import com.marklogic.hub.util.json.JSONStreamWriter;
import com.marklogic.hub.util.json.JSONUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StepDefinitionManagerImpl
extends LoggingObject
implements StepDefinitionManager,
StepDefinitionProvider {
    @Autowired
    private HubConfig hubConfig;
    private HubClient hubClient;
    private HubProject hubProject;

    public StepDefinitionManagerImpl() {
    }

    public StepDefinitionManagerImpl(HubConfig hubConfig) {
        this();
        this.hubConfig = hubConfig;
    }

    public StepDefinitionManagerImpl(HubClient hubClient, HubProject hubProject) {
        this.hubClient = hubClient;
        this.hubProject = hubProject;
    }

    @Override
    public void saveStepDefinition(StepDefinition stepDefinition) {
        this.saveStepDefinition(stepDefinition, false);
    }

    @Override
    public void saveStepDefinition(StepDefinition stepDefinition, boolean autoIncrement) {
        try {
            if (autoIncrement) {
                stepDefinition.incrementVersion();
            }
            this.getArtifactService().setArtifact("stepDefinition", stepDefinition.getName(), JSONUtils.convertArtifactToJson(stepDefinition), stepDefinition.getName());
            Path dir = this.resolvePath(this.getHubProject().getStepDefinitionPath(stepDefinition.getType()), stepDefinition.getName());
            if (!dir.toFile().exists()) {
                dir.toFile().mkdirs();
            }
            String stepFileName = stepDefinition.getName() + ".step.json";
            File file = Paths.get(dir.toString(), stepFileName).toFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JSONStreamWriter jw = new JSONStreamWriter(fileOutputStream);
            jw.write(stepDefinition);
        }
        catch (JsonProcessingException e) {
            throw new DataHubProjectException("Could not serialize Step for project.");
        }
        catch (IOException e) {
            throw new DataHubProjectException("Could not write Step to disk for project.");
        }
    }

    @Override
    public void deleteStepDefinition(StepDefinition stepDefinition) {
        String name = stepDefinition.getName();
        Path dir = this.resolvePath(this.getHubProject().getStepDefinitionPath(stepDefinition.getType()), name);
        if (dir.toFile().exists()) {
            try {
                this.logger.info(this.format("Deleting step definition with name '%s' in directory: %s", new Object[]{name, dir.toFile()}));
                FileUtils.deleteDirectory((File)dir.toFile());
            }
            catch (IOException e) {
                throw new DataHubProjectException(this.format("Could not delete step with name '%s'", new Object[]{name}), e);
            }
        }
    }

    @Override
    public ArrayList<StepDefinition> getStepDefinitions() {
        ArrayList<StepDefinition> stepList = new ArrayList<StepDefinition>();
        for (StepDefinition.StepDefinitionType stepDefinitionType : StepDefinition.StepDefinitionType.getStepDefinitionTypes()) {
            for (String name : this.getStepDefinitionNamesByType(stepDefinitionType)) {
                stepList.add(this.getStepDefinition(name, stepDefinitionType));
            }
        }
        return stepList;
    }

    @Override
    public StepDefinition getStepDefinition(String name, StepDefinition.StepDefinitionType type) {
        Path stepPath = this.resolvePath(this.getHubProject().getStepDefinitionPath(type), name);
        try {
            JsonNode node;
            StepDefinition newStep;
            String targetFileName = name + ".step.json";
            InputStream inputStream = StepDefinitionManagerImpl.class.getResourceAsStream("/hub-internal-artifacts/step-definitions/" + type.toString().toLowerCase() + "/marklogic/" + targetFileName);
            if (inputStream == null) {
                inputStream = new FileInputStream(stepPath.resolve(targetFileName).toFile());
            }
            if ((newStep = this.createStepDefinitionFromJSON(node = JSONObject.readInput(inputStream))) != null && newStep.getName().length() > 0) {
                return newStep;
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw new DataHubProjectException("Could not read Step on disk.");
        }
        return null;
    }

    @Override
    public ArrayList<StepDefinition> getStepDefinitionsByType(StepDefinition.StepDefinitionType type) {
        ArrayList<StepDefinition> stepList = new ArrayList<StepDefinition>();
        for (String name : this.getStepDefinitionNamesByType(type)) {
            stepList.add(this.getStepDefinition(name, type));
        }
        return stepList;
    }

    @Override
    public ArrayList<String> getStepDefinitionNamesByType(StepDefinition.StepDefinitionType type) {
        return (ArrayList)FileUtil.listDirectFolders(this.getHubProject().getStepDefinitionPath(type));
    }

    @Override
    public StepDefinition createStepDefinitionFromJSON(JsonNode json) {
        String stepDefName = null;
        String stepDefType = null;
        if (json.get("name") == null || json.get("name").isNull()) {
            throw new DataHubProjectException("StepDefinition should have a name");
        }
        stepDefName = json.get("name").asText();
        if (json.get("type") == null || json.get("type").isNull()) {
            throw new DataHubProjectException("StepDefinition should have a type");
        }
        stepDefType = json.get("type").asText();
        StepDefinition step = StringUtils.isNotEmpty((CharSequence)stepDefName) && StringUtils.isNotEmpty((CharSequence)stepDefType) ? StepDefinition.create(stepDefName, StepDefinition.StepDefinitionType.getStepDefinitionType(stepDefType)) : StepDefinition.create("default", StepDefinition.StepDefinitionType.CUSTOM);
        step.deserialize(json);
        return step;
    }

    private Path resolvePath(Path path, String more) {
        return path.resolve(more);
    }

    private HubProject getHubProject() {
        return this.hubProject != null ? this.hubProject : this.hubConfig.getHubProject();
    }

    private ArtifactService getArtifactService() {
        DatabaseClient client = this.hubClient != null ? this.hubClient.getStagingClient() : this.hubConfig.newStagingClient(null);
        return ArtifactService.on(client);
    }
}

