/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.step;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.hub.step.impl.Step;
import com.marklogic.hub.util.json.JSONObject;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractStepDefinition
implements StepDefinition {
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final int DEFAULT_THREAD_COUNT = 4;
    private String lang = "zxx";
    private String name;
    private String description = "";
    private StepDefinition.StepDefinitionType type;
    private Integer version = 1;
    private Map<String, Object> options = new HashMap<String, Object>();
    private JsonNode customHook;
    private String modulePath;
    @JsonIgnore
    private String sourceQuery;
    private int retryLimit;
    private Integer batchSize;
    private Integer threadCount;

    protected AbstractStepDefinition() {
        this.options.put("permissions", "data-hub-common,read,data-hub-common,update");
        this.customHook = new JSONObject().jsonNode();
        this.retryLimit = 0;
        this.batchSize = 100;
        this.threadCount = 4;
    }

    @Override
    @Deprecated
    public String getLanguage() {
        return this.lang;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public StepDefinition.StepDefinitionType getType() {
        return this.type;
    }

    @Override
    public void setType(StepDefinition.StepDefinitionType type) {
        this.type = type;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    @Override
    public String getModulePath() {
        return this.modulePath;
    }

    @Override
    public void setModulePath(String path) {
        this.modulePath = path;
    }

    @Override
    public JsonNode getCustomHook() {
        return this.customHook;
    }

    @Override
    public void setCustomHook(JsonNode hookObj) {
        this.customHook = hookObj;
    }

    @Override
    public String getSourceQuery() {
        return this.sourceQuery;
    }

    @Override
    public void setSourceQuery(String sourceQuery) {
        this.sourceQuery = sourceQuery;
    }

    @Override
    public int getRetryLimit() {
        return this.retryLimit;
    }

    @Override
    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    @Override
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public Integer getThreadCount() {
        return this.threadCount;
    }

    @Override
    public void setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
    }

    @Override
    public void incrementVersion() {
        this.setVersion(this.getVersion() + 1);
    }

    @Override
    public void deserialize(JsonNode json) {
        Object sourceQuery;
        Map<String, Object> options;
        JSONObject jsonObject = new JSONObject(json);
        if (jsonObject.isExist("name")) {
            this.setName(jsonObject.getString("name"));
        }
        if (jsonObject.isExist("description")) {
            this.setDescription(jsonObject.getString("description"));
        }
        if (jsonObject.isExist("type")) {
            this.setType(StepDefinition.StepDefinitionType.getStepDefinitionType(jsonObject.getString("type")));
        }
        if (jsonObject.isExist("version")) {
            this.setVersion(jsonObject.getInt("version"));
        }
        if (!(options = jsonObject.getMap("options")).isEmpty()) {
            this.setOptions(jsonObject.getMap("options"));
        }
        if (jsonObject.isExist("customHook")) {
            this.setCustomHook(jsonObject.getNode("customHook"));
        }
        if (jsonObject.isExist("modulePath")) {
            this.setModulePath(jsonObject.getString("modulePath"));
        }
        if (this.options != null && (sourceQuery = this.options.get("sourceQuery")) != null) {
            this.setSourceQuery(sourceQuery.toString());
        }
        if (jsonObject.isExist("retryLimit")) {
            this.setRetryLimit(jsonObject.getInt("retryLimit"));
        }
        if (jsonObject.isExist("batchSize")) {
            this.setBatchSize(jsonObject.getInt("batchSize"));
        }
        if (jsonObject.isExist("threadCount")) {
            this.setThreadCount(jsonObject.getInt("threadCount"));
        }
    }

    @Override
    public Step transformToStep(String stepName, StepDefinition stepDefinition, Step step) {
        step.setStepDefinitionName(stepDefinition.getName());
        step.setStepDefinitionType(stepDefinition.getType());
        step.setName(stepName);
        step.setThreadCount(stepDefinition.getThreadCount());
        step.setBatchSize(stepDefinition.getBatchSize());
        step.setRetryLimit(stepDefinition.getRetryLimit());
        step.setCustomHook(stepDefinition.getCustomHook());
        step.setOptions(stepDefinition.getOptions());
        step.setDescription(stepDefinition.getDescription());
        return step;
    }

    @Override
    public StepDefinition transformFromStep(StepDefinition stepDefinition, Step step) {
        if (step.getName() != null) {
            stepDefinition.setName(step.getName());
        }
        if (step.getBatchSize() != null) {
            stepDefinition.setBatchSize(step.getBatchSize());
        }
        if (step.getDescription() != null) {
            stepDefinition.setDescription(step.getDescription());
        }
        if (step.getThreadCount() != null) {
            stepDefinition.setThreadCount(step.getThreadCount());
        }
        if (step.getOptions() != null) {
            stepDefinition.setOptions(step.getOptions());
        }
        if (step.getCustomHook() != null) {
            stepDefinition.setCustomHook(step.getCustomHook());
        }
        if (step.getRetryLimit() != null) {
            stepDefinition.setRetryLimit(step.getRetryLimit());
        }
        return stepDefinition;
    }
}

