/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.step.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.DatabaseClient;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.util.DiskQueue;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class SourceQueryCollector {
    private HubClient hubClient;
    private String sourceDatabase;

    public SourceQueryCollector(HubClient hubClient, String sourceDatabase) {
        this.hubClient = hubClient;
        this.sourceDatabase = sourceDatabase;
    }

    public DiskQueue<String> run(String flow, String step, Map<String, Object> options) {
        DatabaseClient stagingClient = this.hubClient.getStagingClient();
        try {
            Request request;
            OkHttpClient ok;
            Response response;
            String uriString = String.format("%s://%s:%d/v1/internal/hubcollector5?flow-name=%s&database=%s&step=%s", stagingClient.getSecurityContext().getSSLContext() != null ? "https" : "http", stagingClient.getHost(), stagingClient.getPort(), URLEncoder.encode(flow, "UTF-8"), URLEncoder.encode(this.sourceDatabase, "UTF-8"), URLEncoder.encode(step, "UTF-8"));
            if (options != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                uriString = uriString + "&options=" + URLEncoder.encode(objectMapper.writeValueAsString(options), "UTF-8");
            }
            if ((response = (ok = (OkHttpClient)stagingClient.getClientImplementation()).newCall(request = new Request.Builder().url(uriString).get().build()).execute()).isSuccessful()) {
                return this.readItems(response);
            }
            throw new RuntimeException(String.format("Unable to collect items to process for flow %s and step %s; cause: %s", flow, step, response.body().string()));
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Unexpected IO exception when collecting items to process for flow %s and step %s; cause: %s", flow, step, ex));
        }
    }

    private DiskQueue<String> readItems(Response response) throws IOException {
        DiskQueue<String> results = new DiskQueue<String>(5000);
        try (BufferedReader reader = new BufferedReader(response.body().charStream());){
            String line;
            while ((line = reader.readLine()) != null) {
                results.add(line);
            }
        }
        return results;
    }
}

