/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.step.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.step.RunStepResponse;
import com.marklogic.hub.step.StepDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class StepRunnerUtil {
    protected static RunStepResponse getResponse(JsonNode jobNode, String step) {
        RunStepResponse stepDoc;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            stepDoc = (RunStepResponse)objectMapper.treeToValue((TreeNode)jobNode.get("job").get("stepResponses").get(step), RunStepResponse.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return stepDoc;
    }

    protected static RunStepResponse createStepResponse(Flow flow, String step, String jobId) {
        RunStepResponse runStepResponse = RunStepResponse.withFlow(flow).withStep(step);
        if (jobId == null) {
            jobId = UUID.randomUUID().toString();
        }
        runStepResponse.withJobId(jobId);
        return runStepResponse;
    }

    protected static String jsonToString(JsonNode node) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String objectToString(Object obj) {
        String objStr = null;
        if (obj instanceof String) {
            objStr = (String)obj;
        } else if (obj instanceof TextNode) {
            objStr = ((TextNode)obj).textValue();
        } else if (obj != null) {
            objStr = obj.toString();
        }
        return objStr;
    }

    public static Map<String, Object> makeCombinedOptions(Flow flow, StepDefinition stepDef, String stepNumber, Map<String, Object> runtimeOptions) {
        ObjectMapper mapper = new ObjectMapper();
        Map stepDefMap = null;
        if (stepDef != null) {
            stepDefMap = (Map)mapper.convertValue(stepDef.getOptions(), Map.class);
        }
        Map stepMap = null;
        if (flow.getStep(stepNumber) != null) {
            stepMap = (Map)mapper.convertValue(flow.getStep(stepNumber).getOptions(), Map.class);
        }
        Map flowMap = (Map)mapper.convertValue((Object)flow.getOptions(), Map.class);
        HashMap<String, Object> combinedOptions = new HashMap<String, Object>();
        if (stepDefMap != null) {
            combinedOptions.putAll(stepDefMap);
        }
        if (flowMap != null) {
            combinedOptions.putAll(flowMap);
        }
        if (stepMap != null) {
            combinedOptions.putAll(stepMap);
        }
        if (runtimeOptions != null) {
            combinedOptions.putAll(runtimeOptions);
            StepRunnerUtil.applyStepSpecificOptions(combinedOptions, stepNumber, runtimeOptions);
        }
        return combinedOptions;
    }

    private static void applyStepSpecificOptions(Map<String, Object> combinedOptions, String stepNumber, Map<String, Object> runtimeOptions) {
        if (runtimeOptions.containsKey("stepOptions")) {
            try {
                Map stepOptions = (Map)runtimeOptions.get("stepOptions");
                if (stepOptions.containsKey(stepNumber)) {
                    Map stepSpecificOptions = (Map)stepOptions.get(stepNumber);
                    combinedOptions.putAll(stepSpecificOptions);
                }
            }
            catch (Exception ex) {
                String message = "Unable to apply step-specific options found in 'stepOptions' in runtime options; stepOptions must be a JSON object whose keys are step numbers, and each key has a JSON object as its value, which contains the options specific to that step; error cause: " + ex.getMessage();
                throw new IllegalArgumentException(message);
            }
        }
    }
}

