/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;

public interface ConceptService {
    public static ConceptService on(DatabaseClient db) {
        return ConceptService.on(db, null);
    }

    public static ConceptService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class ConceptServiceImpl
        implements ConceptService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_updateDraftModelInfo;
            private BaseProxy.DBFunctionRequest req_deleteDraftModel;
            private BaseProxy.DBFunctionRequest req_saveConceptModels;
            private BaseProxy.DBFunctionRequest req_createDraftModel;
            private BaseProxy.DBFunctionRequest req_getModelReferences;

            ConceptServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/5/data-services/concept/", servDecl);
                this.req_updateDraftModelInfo = this.baseProxy.request("updateDraftConceptModelInfo.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
                this.req_deleteDraftModel = this.baseProxy.request("deleteDraftConceptModel.sjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_saveConceptModels = this.baseProxy.request("saveConceptModels.sjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
                this.req_createDraftModel = this.baseProxy.request("createDraftConceptModel.sjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
                this.req_getModelReferences = this.baseProxy.request("getConceptReferences.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
            }

            @Override
            public JsonNode updateDraftModelInfo(String name, JsonNode input) {
                return this.updateDraftModelInfo(this.req_updateDraftModelInfo.on(this.dbClient), name, input);
            }

            private JsonNode updateDraftModelInfo(BaseProxy.DBFunctionRequest request, String name, JsonNode input) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"name", (boolean)false, (String)BaseProxy.StringType.fromString((String)name)), BaseProxy.documentParam((String)"input", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)input))}).responseSingle(false, Format.JSON));
            }

            @Override
            public void deleteDraftModel(String conceptName) {
                this.deleteDraftModel(this.req_deleteDraftModel.on(this.dbClient), conceptName);
            }

            private void deleteDraftModel(BaseProxy.DBFunctionRequest request, String conceptName) {
                request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"conceptName", (boolean)false, (String)BaseProxy.StringType.fromString((String)conceptName))}).responseNone();
            }

            @Override
            public void saveConceptModels(JsonNode models) {
                this.saveConceptModels(this.req_saveConceptModels.on(this.dbClient), models);
            }

            private void saveConceptModels(BaseProxy.DBFunctionRequest request, JsonNode models) {
                request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"models", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)models))}).responseNone();
            }

            @Override
            public JsonNode createDraftModel(JsonNode input) {
                return this.createDraftModel(this.req_createDraftModel.on(this.dbClient), input);
            }

            private JsonNode createDraftModel(BaseProxy.DBFunctionRequest request, JsonNode input) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"input", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)input))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getModelReferences(String conceptName) {
                return this.getModelReferences(this.req_getModelReferences.on(this.dbClient), conceptName);
            }

            private JsonNode getModelReferences(BaseProxy.DBFunctionRequest request, String conceptName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"conceptName", (boolean)false, (String)BaseProxy.StringType.fromString((String)conceptName))}).responseSingle(false, Format.JSON));
            }
        }
        return new ConceptServiceImpl(db, serviceDeclaration);
    }

    public JsonNode updateDraftModelInfo(String var1, JsonNode var2);

    public void deleteDraftModel(String var1);

    public void saveConceptModels(JsonNode var1);

    public JsonNode createDraftModel(JsonNode var1);

    public JsonNode getModelReferences(String var1);
}

