/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;

public interface JobService {
    public static JobService on(DatabaseClient db) {
        return JobService.on(db, null);
    }

    public static JobService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class JobServiceImpl
        implements JobService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_startStep;
            private BaseProxy.DBFunctionRequest req_finishStep;
            private BaseProxy.DBFunctionRequest req_getJob;
            private BaseProxy.DBFunctionRequest req_startJob;
            private BaseProxy.DBFunctionRequest req_getJobWithDetails;
            private BaseProxy.DBFunctionRequest req_getMatchingPropertyValues;
            private BaseProxy.DBFunctionRequest req_finishJob;
            private BaseProxy.DBFunctionRequest req_findStepResponses;

            JobServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/5/data-services/job/", servDecl);
                this.req_startStep = this.baseProxy.request("startStep.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
                this.req_finishStep = this.baseProxy.request("finishStep.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
                this.req_getJob = this.baseProxy.request("getJob.sjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_startJob = this.baseProxy.request("startJob.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_getJobWithDetails = this.baseProxy.request("getJobWithDetails.sjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_getMatchingPropertyValues = this.baseProxy.request("getMatchingPropertyValues.sjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
                this.req_finishJob = this.baseProxy.request("finishJob.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_findStepResponses = this.baseProxy.request("findStepResponses.sjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
            }

            @Override
            public JsonNode startStep(String jobId, String stepNumber, String flowName, JsonNode runTimeOptions) {
                return this.startStep(this.req_startStep.on(this.dbClient), jobId, stepNumber, flowName, runTimeOptions);
            }

            private JsonNode startStep(BaseProxy.DBFunctionRequest request, String jobId, String stepNumber, String flowName, JsonNode runTimeOptions) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"jobId", (boolean)false, (String)BaseProxy.StringType.fromString((String)jobId)), BaseProxy.atomicParam((String)"stepNumber", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepNumber)), BaseProxy.atomicParam((String)"flowName", (boolean)false, (String)BaseProxy.StringType.fromString((String)flowName)), BaseProxy.documentParam((String)"runTimeOptions", (boolean)true, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)runTimeOptions))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode finishStep(String jobId, String stepNumber, String stepStatus, JsonNode runStepResponse) {
                return this.finishStep(this.req_finishStep.on(this.dbClient), jobId, stepNumber, stepStatus, runStepResponse);
            }

            private JsonNode finishStep(BaseProxy.DBFunctionRequest request, String jobId, String stepNumber, String stepStatus, JsonNode runStepResponse) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"jobId", (boolean)false, (String)BaseProxy.StringType.fromString((String)jobId)), BaseProxy.atomicParam((String)"stepNumber", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepNumber)), BaseProxy.atomicParam((String)"stepStatus", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepStatus)), BaseProxy.documentParam((String)"runStepResponse", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)runStepResponse))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getJob(String jobId) {
                return this.getJob(this.req_getJob.on(this.dbClient), jobId);
            }

            private JsonNode getJob(BaseProxy.DBFunctionRequest request, String jobId) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"jobId", (boolean)false, (String)BaseProxy.StringType.fromString((String)jobId))}).responseSingle(true, Format.JSON));
            }

            @Override
            public JsonNode startJob(String jobId, String flowName) {
                return this.startJob(this.req_startJob.on(this.dbClient), jobId, flowName);
            }

            private JsonNode startJob(BaseProxy.DBFunctionRequest request, String jobId, String flowName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"jobId", (boolean)false, (String)BaseProxy.StringType.fromString((String)jobId)), BaseProxy.atomicParam((String)"flowName", (boolean)false, (String)BaseProxy.StringType.fromString((String)flowName))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getJobWithDetails(String jobId) {
                return this.getJobWithDetails(this.req_getJobWithDetails.on(this.dbClient), jobId);
            }

            private JsonNode getJobWithDetails(BaseProxy.DBFunctionRequest request, String jobId) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"jobId", (boolean)false, (String)BaseProxy.StringType.fromString((String)jobId))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getMatchingPropertyValues(JsonNode facetValuesSearchQuery) {
                return this.getMatchingPropertyValues(this.req_getMatchingPropertyValues.on(this.dbClient), facetValuesSearchQuery);
            }

            private JsonNode getMatchingPropertyValues(BaseProxy.DBFunctionRequest request, JsonNode facetValuesSearchQuery) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"facetValuesSearchQuery", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)facetValuesSearchQuery))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode finishJob(String jobId, String jobStatus) {
                return this.finishJob(this.req_finishJob.on(this.dbClient), jobId, jobStatus);
            }

            private JsonNode finishJob(BaseProxy.DBFunctionRequest request, String jobId, String jobStatus) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"jobId", (boolean)false, (String)BaseProxy.StringType.fromString((String)jobId)), BaseProxy.atomicParam((String)"jobStatus", (boolean)false, (String)BaseProxy.StringType.fromString((String)jobStatus))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode findStepResponses(JsonNode endpointConstants) {
                return this.findStepResponses(this.req_findStepResponses.on(this.dbClient), endpointConstants);
            }

            private JsonNode findStepResponses(BaseProxy.DBFunctionRequest request, JsonNode endpointConstants) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"endpointConstants", (boolean)true, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)endpointConstants))}).responseSingle(true, Format.JSON));
            }
        }
        return new JobServiceImpl(db, serviceDeclaration);
    }

    public JsonNode startStep(String var1, String var2, String var3, JsonNode var4);

    public JsonNode finishStep(String var1, String var2, String var3, JsonNode var4);

    public JsonNode getJob(String var1);

    public JsonNode startJob(String var1, String var2);

    public JsonNode getJobWithDetails(String var1);

    public JsonNode getMatchingPropertyValues(JsonNode var1);

    public JsonNode finishJob(String var1, String var2);

    public JsonNode findStepResponses(JsonNode var1);
}

