/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;

public interface MappingService {
    public static MappingService on(DatabaseClient db) {
        return MappingService.on(db, null);
    }

    public static MappingService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class MappingServiceImpl
        implements MappingService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_getReferences;
            private BaseProxy.DBFunctionRequest req_getEntitiesForMapping;
            private BaseProxy.DBFunctionRequest req_testMapping;
            private BaseProxy.DBFunctionRequest req_getDocument;
            private BaseProxy.DBFunctionRequest req_getUris;
            private BaseProxy.DBFunctionRequest req_generateMappingTransforms;
            private BaseProxy.DBFunctionRequest req_getMappingFunctions;

            MappingServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/5/data-services/mapping/", servDecl);
                this.req_getReferences = this.baseProxy.request("getReferences.sjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_getEntitiesForMapping = this.baseProxy.request("getEntitiesForMapping.sjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_testMapping = this.baseProxy.request("testMapping.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
                this.req_getDocument = this.baseProxy.request("getDocument.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_getUris = this.baseProxy.request("getUris.sjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_generateMappingTransforms = this.baseProxy.request("generateMappingTransforms.sjs", BaseProxy.ParameterValuesKind.NONE);
                this.req_getMappingFunctions = this.baseProxy.request("getMappingFunctions.sjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
            }

            @Override
            public JsonNode getReferences(String stepName) {
                return this.getReferences(this.req_getReferences.on(this.dbClient), stepName);
            }

            private JsonNode getReferences(BaseProxy.DBFunctionRequest request, String stepName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"stepName", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepName))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getEntitiesForMapping(String entityName) {
                return this.getEntitiesForMapping(this.req_getEntitiesForMapping.on(this.dbClient), entityName);
            }

            private JsonNode getEntitiesForMapping(BaseProxy.DBFunctionRequest request, String entityName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"entityName", (boolean)false, (String)BaseProxy.StringType.fromString((String)entityName))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode testMapping(String uri, String database, JsonNode jsonMapping) {
                return this.testMapping(this.req_testMapping.on(this.dbClient), uri, database, jsonMapping);
            }

            private JsonNode testMapping(BaseProxy.DBFunctionRequest request, String uri, String database, JsonNode jsonMapping) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"uri", (boolean)false, (String)BaseProxy.StringType.fromString((String)uri)), BaseProxy.atomicParam((String)"database", (boolean)false, (String)BaseProxy.StringType.fromString((String)database)), BaseProxy.documentParam((String)"jsonMapping", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)jsonMapping))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getDocument(String stepName, String uri) {
                return this.getDocument(this.req_getDocument.on(this.dbClient), stepName, uri);
            }

            private JsonNode getDocument(BaseProxy.DBFunctionRequest request, String stepName, String uri) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"stepName", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepName)), BaseProxy.atomicParam((String)"uri", (boolean)false, (String)BaseProxy.StringType.fromString((String)uri))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getUris(String stepName, Integer limit) {
                return this.getUris(this.req_getUris.on(this.dbClient), stepName, limit);
            }

            private JsonNode getUris(BaseProxy.DBFunctionRequest request, String stepName, Integer limit) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"stepName", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepName)), BaseProxy.atomicParam((String)"limit", (boolean)false, (String)BaseProxy.IntegerType.fromInteger((Integer)limit))}).responseSingle(false, Format.JSON));
            }

            @Override
            public void generateMappingTransforms() {
                this.generateMappingTransforms(this.req_generateMappingTransforms.on(this.dbClient));
            }

            private void generateMappingTransforms(BaseProxy.DBFunctionRequest request) {
                request.responseNone();
            }

            @Override
            public JsonNode getMappingFunctions() {
                return this.getMappingFunctions(this.req_getMappingFunctions.on(this.dbClient), false);
            }

            @Override
            public JsonNode getMappingFunctions(Boolean excludeMLMappingFunctions) {
                return this.getMappingFunctions(this.req_getMappingFunctions.on(this.dbClient), excludeMLMappingFunctions);
            }

            private JsonNode getMappingFunctions(BaseProxy.DBFunctionRequest request, Boolean excludeMLMappingFunctions) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"excludeMLMappingFunctions", (boolean)true, (String)BaseProxy.BooleanType.fromBoolean((Boolean)excludeMLMappingFunctions))}).responseSingle(false, Format.JSON));
            }
        }
        return new MappingServiceImpl(db, serviceDeclaration);
    }

    public JsonNode getReferences(String var1);

    public JsonNode getEntitiesForMapping(String var1);

    public JsonNode testMapping(String var1, String var2, JsonNode var3);

    public JsonNode getDocument(String var1, String var2);

    public JsonNode getUris(String var1, Integer var2);

    public void generateMappingTransforms();

    public JsonNode getMappingFunctions(Boolean var1);

    public JsonNode getMappingFunctions();
}

