/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.databases.DeployDatabaseCommand;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.deploy.util.ResourceUtil;
import com.marklogic.hub.error.DataHubConfigurationException;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import com.marklogic.rest.util.JsonNodeUtil;
import java.io.File;
import java.io.IOException;

public class DeployHubDatabaseCommand
extends DeployDatabaseCommand {
    private HubConfig hubConfig;
    private String databaseFilename;
    private File databaseFile;
    private boolean mergeEntityConfigFiles = true;
    private boolean mergeExistingArrayProperties = false;
    private boolean removeSchemaAndTriggersDatabaseSettings = false;

    public DeployHubDatabaseCommand(HubConfig hubConfig, File databaseFile, String databaseFilename) {
        super(databaseFilename);
        if (databaseFile != null) {
            super.setDatabaseFile(databaseFile);
        }
        this.databaseFile = databaseFile;
        this.hubConfig = hubConfig;
        this.databaseFilename = databaseFilename;
        if (databaseFilename != null) {
            this.setForestFilename(databaseFilename.replace("-database", "-forest"));
        }
    }

    public void execute(CommandContext context) {
        if (this.databaseFile != null && this.logger.isInfoEnabled()) {
            this.logger.info("Processing file: " + this.databaseFile);
        }
        super.execute(context);
    }

    protected String getPayload(CommandContext context) {
        String payload = super.getPayload(context);
        return payload != null ? this.preparePayloadBeforeSubmitting(context, payload) : null;
    }

    protected String preparePayloadBeforeSubmitting(CommandContext context, String payload) {
        try {
            ObjectNode payloadNode = (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(payload);
            if (this.mergeEntityConfigFiles) {
                payloadNode = this.mergePayloadWithEntityConfigFileIfItExists(context, payloadNode);
            }
            if (this.mergeExistingArrayProperties) {
                payloadNode = this.mergeExistingArrayProperties(context, payloadNode);
            }
            this.removeSchemaAndTriggersDatabaseSettings(payloadNode);
            if (payloadNode.has("language") && "zxx".equalsIgnoreCase(payloadNode.get("language").asText())) {
                this.logger.warn("Removing 'language' property because it has a value of 'zxx'; complete payload: " + payload);
                payloadNode.remove("language");
            }
            return payloadNode.toString();
        }
        catch (IOException e) {
            throw new DataHubConfigurationException(e);
        }
    }

    private ObjectNode mergeExistingArrayProperties(CommandContext context, ObjectNode propertiesToSave) {
        if (!propertiesToSave.has("database-name")) {
            this.logger.warn("Database payload unexpectedly does not have 'database-name' property; will not merge existing array properties: " + propertiesToSave);
            return propertiesToSave;
        }
        String dbName = propertiesToSave.get("database-name").asText();
        try {
            String json = new DatabaseManager(context.getManageClient()).getPropertiesAsJson(dbName, new String[0]);
            ObjectNode existingProperties = (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(json);
            return ResourceUtil.mergeExistingArrayProperties(propertiesToSave, existingProperties);
        }
        catch (Exception ex) {
            throw new RuntimeException(this.format("Unexpected error when trying to merge existing array properties for database '%s'; cause: " + ex.getMessage(), new Object[]{dbName}), ex);
        }
    }

    protected ObjectNode mergePayloadWithEntityConfigFileIfItExists(CommandContext context, ObjectNode payloadNode) throws IOException {
        File entityDatabaseFile;
        File entityDatabaseDir;
        if (this.hubConfig.getEntityDatabaseDir() != null && this.databaseFilename != null && (entityDatabaseDir = this.hubConfig.getEntityDatabaseDir().toFile()) != null && (entityDatabaseFile = new File(entityDatabaseDir, this.databaseFilename)) != null && entityDatabaseFile.exists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Merging in file: " + entityDatabaseFile.getAbsolutePath());
            }
            String entityConfigPayload = this.readResourceFromFile(context, entityDatabaseFile);
            ObjectNode entityConfigNode = (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(entityConfigPayload);
            return JsonNodeUtil.mergeObjectNodes((ObjectNode[])new ObjectNode[]{payloadNode, entityConfigNode});
        }
        return payloadNode;
    }

    private void removeSchemaAndTriggersDatabaseSettings(ObjectNode payload) {
        if (this.removeSchemaAndTriggersDatabaseSettings) {
            payload.remove("schema-database");
            payload.remove("triggers-database");
        }
    }

    public void setMergeEntityConfigFiles(boolean mergeEntityConfigFiles) {
        this.mergeEntityConfigFiles = mergeEntityConfigFiles;
    }

    public void setRemoveSchemaAndTriggersDatabaseSettings(boolean removeSchemaAndTriggersDatabaseSettings) {
        this.removeSchemaAndTriggersDatabaseSettings = removeSchemaAndTriggersDatabaseSettings;
    }

    public boolean isRemoveSchemaAndTriggersDatabaseSettings() {
        return this.removeSchemaAndTriggersDatabaseSettings;
    }

    public void setMergeExistingArrayProperties(boolean mergeExistingArrayProperties) {
        this.mergeExistingArrayProperties = mergeExistingArrayProperties;
    }
}

