/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.hub.entity.ItemType;
import com.marklogic.hub.entity.JsonPojo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PropertyType
extends JsonPojo {
    protected String name;
    protected String datatype;
    protected String description;
    @JsonProperty(value="$ref")
    protected String ref;
    protected String collation;
    ItemType items;
    protected List<PropertyType> subProperties;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getCollation() {
        return this.collation;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public ItemType getItems() {
        return this.items;
    }

    public void setItems(ItemType items) {
        this.items = items;
    }

    public List<PropertyType> getSubProperties() {
        return this.subProperties;
    }

    public void setSubProperties(List<PropertyType> subProperties) {
        this.subProperties = subProperties;
    }

    public static PropertyType fromJson(String name, JsonNode defs) {
        JsonNode propertiesNode;
        PropertyType propertyType = new PropertyType();
        propertyType.name = name;
        propertyType.datatype = PropertyType.getValue(defs, "datatype");
        propertyType.description = PropertyType.getValue(defs, "description");
        propertyType.ref = PropertyType.getValue(defs, "$ref");
        propertyType.collation = PropertyType.getValue(defs, "collation");
        JsonNode itemsNode = defs.get("items");
        if (itemsNode != null) {
            propertyType.setItems(ItemType.fromJson(itemsNode));
        }
        if ((propertiesNode = defs.get("subProperties")) != null) {
            ArrayList<PropertyType> subProperties = new ArrayList<PropertyType>();
            Iterator fieldItr = propertiesNode.fieldNames();
            while (fieldItr.hasNext()) {
                String key = (String)fieldItr.next();
                JsonNode propertyNode = propertiesNode.get(key);
                if (propertyNode == null) continue;
                subProperties.add(PropertyType.fromJson(key, propertyNode));
            }
            propertyType.setSubProperties(subProperties);
        }
        return propertyType;
    }

    @Override
    public JsonNode toJson() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        PropertyType.writeStringIf(node, "datatype", this.datatype);
        PropertyType.writeStringIf(node, "description", this.description);
        PropertyType.writeStringIf(node, "$ref", this.ref);
        PropertyType.writeStringIf(node, "collation", this.collation);
        if (this.items != null && this.items.hasValues()) {
            node.set("items", this.items.toJson());
        }
        if (this.subProperties != null && !this.subProperties.isEmpty()) {
            ObjectNode propertiesObj = JsonNodeFactory.instance.objectNode();
            for (PropertyType prop : this.subProperties) {
                propertiesObj.set(prop.getName(), prop.toJson());
            }
            node.set("subProperties", (JsonNode)propertiesObj);
        }
        return node;
    }
}

