/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.ext.mlunittest;

import com.marklogic.client.ext.helper.LoggingObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class TestSuiteGenerator
extends LoggingObject {
    public List<File> generateTestSuite(Path sourcePath, String suiteName) {
        return this.generateTestSuite(sourcePath, suiteName, null);
    }

    public List<File> generateTestSuite(Path sourcePath, String suiteName, String testModuleName) {
        File suiteDir;
        Assert.notNull((Object)sourcePath, (String)"sourcePath must be specified");
        Assert.notNull((Object)suiteName, (String)"suiteName must be specified");
        if (StringUtils.isEmpty((Object)testModuleName)) {
            testModuleName = "test";
        }
        if (!(suiteDir = sourcePath.resolve("root").resolve("test").resolve("suites").resolve(suiteName).toFile()).mkdirs() && !suiteDir.exists()) {
            this.logger.warn("Unable to create directory for test suite: " + suiteDir.getAbsolutePath());
        }
        ArrayList<File> generatedFiles = new ArrayList<File>();
        this.writeFile(new File(suiteDir, "suiteSetup.sjs"), "// Uncomment the three lines below to prepare the databases once before all test modules are run.\n// If you instead want to prepare the databases before each test module is run, modify setup.sjs .\n\n// declareUpdate();\n// const dhmut = require('/data-hub/public/marklogic-unit-test/hub-test-helper.xqy');\n// dhmut.prepareDatabases();", generatedFiles);
        this.writeFile(new File(suiteDir, "setup.sjs"), "// Uses the Data Hub test helper library to prepare the staging, final, and job databases before each test module is run.\n// If you need this functionality instead at the suite level, just remove the code below and modify the generated suiteSetup.sjs file.\n// If you do not need this functionality, it is safe to delete the code below and/or this module.\n\ndeclareUpdate();\nconst dhmut = require('/data-hub/public/marklogic-unit-test/hub-test-helper.xqy');\ndhmut.prepareDatabases();", generatedFiles);
        this.writeFile(new File(suiteDir, testModuleName + ".sjs"), "// Example test module that performs a single assertion and returns an array containing the result of that single assertion.\n// This is a simple starting point for a test module; modify as needed.\n\nconst test = require('/test/test-helper.xqy');\n\nconst assertions = [];\n\nassertions.push(test.assertEqual(true, true));\n\nassertions", generatedFiles);
        return generatedFiles;
    }

    private void writeFile(File file, String content, List<File> generatedFiles) {
        if (file.exists()) {
            this.logger.warn("File already exists, will not overwrite: " + file.getAbsolutePath());
        } else {
            try {
                FileCopyUtils.copy((byte[])content.getBytes(StandardCharsets.UTF_8), (File)file);
                generatedFiles.add(file);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write unit test file: " + file.getAbsolutePath() + "; cause: " + e.getMessage());
            }
        }
    }
}

