/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.hubcentral.conversion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.DeleteListener;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.query.QueryManager;
import com.marklogic.client.query.StructuredQueryBuilder;
import com.marklogic.client.query.StructuredQueryDefinition;
import com.marklogic.hub.FlowManager;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.MappingManager;
import com.marklogic.hub.dataservices.MasteringService;
import com.marklogic.hub.error.DataHubProjectException;
import com.marklogic.hub.impl.FlowManagerImpl;
import com.marklogic.hub.impl.MappingManagerImpl;
import com.marklogic.hub.impl.StepManager;
import com.marklogic.hub.mapping.Mapping;
import com.marklogic.hub.step.StepDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.springframework.util.StringUtils;

public class FlowConverter
extends LoggingObject {
    private MappingManager mappingManager;
    private FlowManager flowManager;
    private StepManager stepManager;
    private HubConfig hubConfig;
    private ObjectMapper mapper = new ObjectMapper();

    public FlowConverter(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
        this.mappingManager = new MappingManagerImpl(hubConfig);
        this.flowManager = new FlowManagerImpl(hubConfig, this.mappingManager);
        this.stepManager = new StepManager(hubConfig);
    }

    public void deleteLegacyMappings() {
        this.logger.info("Deleting legacy mappings in staging and final databases");
        HubClient hubClient = this.hubConfig.newHubClient();
        Stream.of(hubClient.getStagingClient(), hubClient.getFinalClient()).forEach(client -> {
            DataMovementManager dmm = client.newDataMovementManager();
            QueryManager queryManager = client.newQueryManager();
            StructuredQueryBuilder queryBuilder = queryManager.newStructuredQueryBuilder();
            StructuredQueryDefinition query = queryBuilder.andNot(queryBuilder.collection(new String[]{"http://marklogic.com/data-hub/mappings"}), queryBuilder.collection(new String[]{"http://marklogic.com/data-hub/steps"}));
            QueryBatcher queryBatcher = dmm.newQueryBatcher(query).withConsistentSnapshot().withBatchSize(100).withThreadCount(4).onUrisReady((QueryBatchListener)new DeleteListener());
            dmm.startJob(queryBatcher);
            queryBatcher.awaitCompletion();
            dmm.stopJob((Batcher)queryBatcher);
        });
    }

    public void convertFlows() {
        HubProject hubProject = this.hubConfig.getHubProject();
        File flowsDir = hubProject.getFlowsDir().toFile();
        if (!flowsDir.exists()) {
            this.logger.warn("No flows directory exists, so no flows will be converted");
            return;
        }
        this.logger.warn("Beginning conversion of flows");
        Path convertedFlowsPath = hubProject.getProjectDir().resolve("converted-flows");
        try {
            convertedFlowsPath.toFile().mkdirs();
            FileUtils.copyDirectory((File)flowsDir, (File)convertedFlowsPath.resolve("flows").toFile());
            File mappingsDir = hubProject.getHubMappingsDir().toFile();
            if (mappingsDir.exists()) {
                FileUtils.copyDirectory((File)mappingsDir, (File)convertedFlowsPath.resolve("mappings").toFile());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't convert flows as backing up flows failed : " + e.getMessage(), e);
        }
        Path ingestionDir = hubProject.getStepsPath(StepDefinition.StepDefinitionType.INGESTION);
        Path mappingDir = hubProject.getStepsPath(StepDefinition.StepDefinitionType.MAPPING);
        Path matchingDir = hubProject.getStepsPath(StepDefinition.StepDefinitionType.MATCHING);
        Path mergingDir = hubProject.getStepsPath(StepDefinition.StepDefinitionType.MERGING);
        Path masteringDir = hubProject.getStepsPath(StepDefinition.StepDefinitionType.MASTERING);
        Path customStepDir = hubProject.getStepsPath(StepDefinition.StepDefinitionType.CUSTOM);
        try {
            ingestionDir.toFile().mkdirs();
            mappingDir.toFile().mkdirs();
            matchingDir.toFile().mkdirs();
            mergingDir.toFile().mkdirs();
            masteringDir.toFile().mkdirs();
            customStepDir.toFile().mkdirs();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't convert flows as creation of step artifact directories failed : " + e.getMessage(), e);
        }
        ObjectWriter writer = this.mapper.writerWithDefaultPrettyPrinter();
        JsonNodeFactory nodeFactory = this.mapper.getNodeFactory();
        for (ObjectNode flowNode : this.flowManager.getLocalFlowsAsJSON()) {
            String flowName = flowNode.get("name").asText();
            this.logger.warn(this.format("Converting flow '%s'", new Object[]{flowName}));
            ObjectNode stepsNode = (ObjectNode)flowNode.get("steps");
            Iterator entryIterator = stepsNode.fields();
            while (entryIterator.hasNext()) {
                Path targetDir;
                String stepId;
                Map.Entry entry = (Map.Entry)entryIterator.next();
                ObjectNode stepNode = (ObjectNode)entry.getValue();
                if (stepNode.has("stepId")) {
                    boolean bl;
                    ObjectNode refStepNode;
                    stepId = stepNode.get("stepId").asText();
                    String stepDefTypeStr = stepId.substring(stepId.lastIndexOf("-") + 1).toLowerCase();
                    StepDefinition.StepDefinitionType stepDefType = StepDefinition.StepDefinitionType.getStepDefinitionType(stepDefTypeStr);
                    if (stepDefType.equals((Object)StepDefinition.StepDefinitionType.MATCHING) && !stepNode.has("matchRulesets")) {
                        refStepNode = this.stepManager.getLocalStepAsJSON(stepId);
                        this.transformMatchingOptions(refStepNode);
                        this.stepManager.saveLocalStep(refStepNode);
                        bl = false;
                        continue;
                    }
                    if (!stepDefType.equals((Object)StepDefinition.StepDefinitionType.MERGING) || stepNode.has("mergeRules")) continue;
                    refStepNode = this.stepManager.getLocalStepAsJSON(stepId);
                    this.transformMergingOptions(refStepNode);
                    this.stepManager.saveLocalStep(refStepNode);
                    bl = false;
                    continue;
                }
                String stepName = this.getStepName(stepNode);
                StepDefinition.StepDefinitionType stepDefType = StepDefinition.StepDefinitionType.getStepDefinitionType(stepNode.get("stepDefinitionType").asText());
                if (StepDefinition.StepDefinitionType.INGESTION.equals((Object)stepDefType)) {
                    targetDir = ingestionDir;
                    stepId = String.join((CharSequence)"-", stepName, StepDefinition.StepDefinitionType.INGESTION.toString());
                } else if (StepDefinition.StepDefinitionType.MATCHING.equals((Object)stepDefType)) {
                    targetDir = matchingDir;
                    stepId = String.join((CharSequence)"-", stepName, StepDefinition.StepDefinitionType.MATCHING.toString());
                } else if (StepDefinition.StepDefinitionType.MERGING.equals((Object)stepDefType)) {
                    targetDir = mergingDir;
                    stepId = String.join((CharSequence)"-", stepName, StepDefinition.StepDefinitionType.MERGING.toString());
                } else if (StepDefinition.StepDefinitionType.MASTERING.equals((Object)stepDefType)) {
                    if ("default-mastering".equalsIgnoreCase(stepNode.get("stepDefinitionName").asText())) {
                        targetDir = masteringDir;
                        stepId = String.join((CharSequence)"-", stepName, StepDefinition.StepDefinitionType.MASTERING.toString());
                    } else {
                        this.logger.warn(this.format("The mastering step '%s' will be converted to a custom step (step with step definition type 'custom').", new Object[]{stepName}));
                        targetDir = customStepDir;
                        stepId = String.join((CharSequence)"-", stepName, StepDefinition.StepDefinitionType.CUSTOM.toString());
                        stepNode.put("stepDefinitionType", StepDefinition.StepDefinitionType.CUSTOM.toString());
                    }
                } else if (StepDefinition.StepDefinitionType.MAPPING.equals((Object)stepDefType)) {
                    if ("entity-services-mapping".equalsIgnoreCase(stepNode.get("stepDefinitionName").asText()) || this.getMappingArtifact(flowName, (JsonNode)stepNode) != null) {
                        targetDir = mappingDir;
                        stepId = String.join((CharSequence)"-", stepName, StepDefinition.StepDefinitionType.MAPPING.toString());
                    } else {
                        this.logger.warn(this.format("The custom mapping step '%s' will be converted to a custom step (step with step definition type 'custom') as a valid mapping can't be found.", new Object[]{stepName}));
                        targetDir = customStepDir;
                        stepId = String.join((CharSequence)"-", stepName, StepDefinition.StepDefinitionType.CUSTOM.toString());
                        stepNode.put("stepDefinitionType", StepDefinition.StepDefinitionType.CUSTOM.toString());
                    }
                } else {
                    targetDir = customStepDir;
                    stepId = String.join((CharSequence)"-", stepName, StepDefinition.StepDefinitionType.CUSTOM.toString());
                    if (!StepDefinition.StepDefinitionType.CUSTOM.equals((Object)stepDefType)) {
                        this.logger.warn(this.format("The custom mastering step '%s' will be converted to a custom step (step with step definition type 'custom')", new Object[]{stepName}));
                    }
                    stepNode.put("stepDefinitionType", StepDefinition.StepDefinitionType.CUSTOM.toString());
                }
                ObjectNode newStepArtifact = this.createStepArtifact(flowName, (JsonNode)stepNode);
                stepsNode.set((String)entry.getKey(), (JsonNode)nodeFactory.objectNode().put("stepId", stepId));
                String stepFileName = stepName + ".step.json";
                File stepFile = targetDir.resolve(stepFileName).toFile();
                this.logger.info(this.format("Creating step artifact '%s'", new Object[]{stepFile.toString()}));
                if (stepFile.exists()) {
                    String msg = "Step artifact '" + stepFile.toString() + "' already exists. The step artifact will be written to ";
                    stepName = flowName + "-" + stepName;
                    newStepArtifact.put("name", stepName);
                    stepFileName = flowName + "-" + stepFileName;
                    stepFile = targetDir.resolve(stepFileName).toFile();
                    this.logger.warn(msg + stepFile.toString());
                    stepId = flowName + "-" + stepId;
                    stepsNode.set((String)entry.getKey(), (JsonNode)nodeFactory.objectNode().put("stepId", stepId));
                }
                newStepArtifact.put("stepId", stepId);
                if (stepDefType.equals((Object)StepDefinition.StepDefinitionType.MATCHING)) {
                    this.transformMatchingOptions(newStepArtifact);
                } else if (stepDefType.equals((Object)StepDefinition.StepDefinitionType.MERGING)) {
                    this.transformMergingOptions(newStepArtifact);
                }
                try {
                    writer.writeValue(stepFile, (Object)newStepArtifact);
                    this.logger.warn(this.format("Step artifact '%s' successfully created", new Object[]{stepFile}));
                }
                catch (IOException e) {
                    this.logger.error(this.format("Step artifact '%s' creation failed; cause: %s.", new Object[]{stepFile, e.getMessage(), e}));
                }
            }
            File flowFile = Paths.get(hubProject.getFlowsDir().toString(), flowName + ".flow.json").toFile();
            try {
                writer.writeValue(flowFile, (Object)flowNode);
                this.logger.warn(this.format("Flow '%s' was successfully converted", new Object[]{flowFile}));
            }
            catch (IOException e) {
                this.logger.error(this.format("Flow '%s' conversion failed; cause: %s", new Object[]{flowFile, e.getMessage()}), (Throwable)e);
            }
        }
        this.logger.warn("The original flows and mappings have been backed up to the converted-flows/flows and converted-flows/mappings directories respectively");
        if (hubProject.getHubMappingsDir().toFile().exists()) {
            try {
                this.logger.warn("Removing 'mappings' directory from the project as it is no longer needed");
                FileUtils.deleteDirectory((File)hubProject.getHubMappingsDir().toFile());
            }
            catch (IOException e) {
                this.logger.error("Removing 'mappings' directory from the project failed; cause: " + e, (Throwable)e);
            }
        }
        this.logger.warn("");
        this.logger.warn("Finished converting flows.");
        this.logger.warn("Please examine the converted flow and step artifact to verify their contents, particularly the collections of each step.");
        this.logger.warn("The conversion process ensures that steps have their step name as a collection, and that a mapping (and custom if entity name is present) step has its entity name as a collection.");
    }

    protected String getStepName(ObjectNode stepNode) {
        String stepName = stepNode.has("name") ? stepNode.get("name").asText() : StepDefinition.StepDefinitionType.getStepDefinitionType(stepNode.get("stepDefinitionType").asText()).toString();
        return stepName;
    }

    protected Mapping getMappingArtifact(String flowName, JsonNode inlineStep) {
        Mapping mapping = null;
        JsonNode mappingNode = inlineStep.get("options").get("mapping");
        if (mappingNode != null) {
            if (!mappingNode.has("name")) {
                this.logger.warn(this.format("Unable to convert mapping in flow '%s' because it does not have a 'name' property", new Object[0]));
            } else {
                String mappingName = mappingNode.get("name").asText();
                int version = 0;
                if (mappingNode.has("version")) {
                    String versionText = mappingNode.get("version").asText();
                    try {
                        version = Integer.parseInt(versionText);
                    }
                    catch (Exception ex) {
                        this.logger.warn(this.format("Unable to parse version '%s' from step '%s' in flow '%s'; will use zero as the version instead", new Object[]{versionText, inlineStep.get("name").asText(), flowName}));
                    }
                }
                try {
                    mapping = this.mappingManager.getMapping(mappingName, version, false);
                }
                catch (DataHubProjectException e) {
                    this.logger.warn(this.format("Mapping '%s' with version '%s' was not found; the mapping properties will not be written to the step artifact named '%s' which was extracted from flow '%s'", new Object[]{mappingName, version, inlineStep.get("name").asText(), flowName}));
                }
            }
        }
        return mapping;
    }

    protected ObjectNode createStepArtifact(String flowName, JsonNode inlineStep) {
        Mapping mapping = null;
        if (this.stepDefTypeEqual(StepDefinition.StepDefinitionType.MAPPING, inlineStep.get("stepDefinitionType"))) {
            mapping = this.getMappingArtifact(flowName, inlineStep);
        }
        return this.buildStepArtifact(inlineStep, mapping, flowName);
    }

    protected ObjectNode buildStepArtifact(JsonNode inlineStep, Mapping mapping, String flowName) {
        ObjectNode stepArtifact = (ObjectNode)inlineStep.deepCopy();
        stepArtifact.remove("options");
        JsonNode options = inlineStep.get("options");
        if (options != null) {
            HashSet<String> fieldsNotToBeCopied = new HashSet<String>();
            fieldsNotToBeCopied.add("mapping");
            fieldsNotToBeCopied.add("sourceCollection");
            options.fields().forEachRemaining(kv -> {
                JsonNode value;
                if ((!fieldsNotToBeCopied.contains(kv.getKey()) || inlineStep.get("stepDefinitionType").asText().equals(StepDefinition.StepDefinitionType.CUSTOM.toString())) && (value = (JsonNode)kv.getValue()) != null) {
                    stepArtifact.set((String)kv.getKey(), value);
                }
            });
        }
        stepArtifact.put("targetFormat", stepArtifact.get("outputFormat") != null ? stepArtifact.get("outputFormat").asText() : "json");
        stepArtifact.remove("outputFormat");
        if (stepArtifact.has("customHook")) {
            JsonNode hook = stepArtifact.get("customHook");
            boolean removeHook = false;
            if (!hook.has("module")) {
                removeHook = true;
            }
            if (hook.has("module") && StringUtils.isEmpty((Object)hook.get("module").asText().trim())) {
                removeHook = true;
            }
            if (removeHook) {
                stepArtifact.remove("customHook");
            }
        }
        stepArtifact.remove("retryLimit");
        JsonNode fileLocations = inlineStep.get("fileLocations");
        if (fileLocations != null) {
            fileLocations.fields().forEachRemaining(field -> stepArtifact.set((String)field.getKey(), (JsonNode)field.getValue()));
            stepArtifact.remove("fileLocations");
            stepArtifact.put("sourceFormat", stepArtifact.get("inputFileType") != null ? stepArtifact.get("inputFileType").asText() : "json");
            stepArtifact.remove("inputFileType");
        }
        if (mapping != null) {
            stepArtifact.put("targetEntityType", mapping.getTargetEntityType());
            stepArtifact.set("properties", this.mapper.valueToTree(mapping.getProperties()));
            if (mapping.getNamespaces() != null) {
                stepArtifact.set("namespaces", this.mapper.valueToTree(mapping.getNamespaces()));
            }
            stepArtifact.put("selectedSource", "query");
        }
        if ((this.stepDefTypeEqual(StepDefinition.StepDefinitionType.MAPPING, inlineStep.get("stepDefinitionType")) || this.stepDefTypeEqual(StepDefinition.StepDefinitionType.MATCHING, inlineStep.get("stepDefinitionType")) || this.stepDefTypeEqual(StepDefinition.StepDefinitionType.MERGING, inlineStep.get("stepDefinitionType")) || this.stepDefTypeEqual(StepDefinition.StepDefinitionType.CUSTOM, inlineStep.get("stepDefinitionType"))) && stepArtifact.has("targetEntity")) {
            if (!stepArtifact.has("targetEntityType")) {
                stepArtifact.put("targetEntityType", stepArtifact.get("targetEntity").asText());
            }
            stepArtifact.remove("targetEntity");
        }
        Stream.of("batchSize", "threadCount").forEach(prop -> {
            if (stepArtifact.has(prop) && "0".equals(stepArtifact.get(prop).asText())) {
                stepArtifact.remove(prop);
            }
        });
        this.addToCollections(stepArtifact, inlineStep, flowName);
        return stepArtifact;
    }

    private boolean stepDefTypeEqual(StepDefinition.StepDefinitionType type, JsonNode node) {
        if (node == null) {
            return false;
        }
        return node.asText().equalsIgnoreCase(type.toString());
    }

    protected void addToCollections(ObjectNode stepArtifact, JsonNode inlineStep, String flowName) {
        ArrayNode collections;
        if (stepArtifact.has("collections")) {
            JsonNode node = stepArtifact.get("collections");
            if (node instanceof ArrayNode) {
                collections = (ArrayNode)node;
            } else {
                collections = this.mapper.createArrayNode();
                collections.add(node.asText());
            }
        } else {
            collections = this.mapper.createArrayNode();
        }
        String stepName = inlineStep.get("name").asText();
        String targetEntityName = stepArtifact.has("targetEntityType") ? this.getEntityNameFromEntityType(stepArtifact.get("targetEntityType").asText()) : null;
        boolean stepNameExists = false;
        boolean targetEntityNameExists = false;
        Iterator arrayItems = collections.elements();
        while (arrayItems.hasNext()) {
            String collection = ((JsonNode)arrayItems.next()).asText();
            if (stepName.equals(collection)) {
                stepNameExists = true;
            }
            if (targetEntityName == null || !targetEntityName.equals(collection)) continue;
            targetEntityNameExists = true;
        }
        if (!stepNameExists) {
            this.logger.warn(this.format("Adding step name as a collection to step '%s' in flow '%s'", new Object[]{stepName, flowName}));
            collections.add(stepName);
        }
        if (targetEntityName != null && !targetEntityNameExists) {
            this.logger.warn(this.format("Adding entity name '%s' as a collection to step '%s' in flow '%s'", new Object[]{targetEntityName, stepName, flowName}));
            collections.add(targetEntityName);
        }
        stepArtifact.set("collections", (JsonNode)collections);
    }

    protected String getEntityNameFromEntityType(String targetEntityType) {
        int index = targetEntityType.lastIndexOf("/");
        return index > -1 ? targetEntityType.substring(index + 1) : targetEntityType;
    }

    protected void transformMatchingOptions(ObjectNode stepNode) {
        JsonNode beforeNode = stepNode.get("matchOptions");
        if (beforeNode == null) {
            return;
        }
        JsonNode afterNode = MasteringService.on(this.hubConfig.newHubClient().getStagingClient()).updateMatchOptions(beforeNode);
        if (stepNode.has("targetEntity")) {
            stepNode.set("targetEntityType", stepNode.get("targetType"));
            stepNode.remove("targetType");
        }
        stepNode.remove("matchOptions");
        Iterator fieldNames = afterNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode node = afterNode.get(fieldName);
            stepNode.set(fieldName, node);
        }
    }

    protected void transformMergingOptions(ObjectNode stepNode) {
        JsonNode beforeNode = stepNode.get("mergeOptions");
        if (beforeNode == null) {
            return;
        }
        JsonNode afterNode = MasteringService.on(this.hubConfig.newHubClient().getStagingClient()).updateMergeOptions(beforeNode);
        if (stepNode.has("targetEntity")) {
            stepNode.set("targetEntityType", stepNode.get("targetType"));
            stepNode.remove("targetType");
        }
        stepNode.remove("mergeOptions");
        Iterator fieldNames = afterNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode node = afterNode.get(fieldName);
            stepNode.set(fieldName, node);
        }
    }
}

