/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.file.PermissionsDocumentFileProcessor;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.modulesloader.impl.AssetFileLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultModulesLoader;
import com.marklogic.client.extensions.ResourceManager;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.util.RequestParameters;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.EntityManager;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.dataservices.ModelsService;
import com.marklogic.hub.entity.DefinitionType;
import com.marklogic.hub.entity.DefinitionsType;
import com.marklogic.hub.entity.HubEntity;
import com.marklogic.hub.entity.InfoType;
import com.marklogic.hub.entity.ItemType;
import com.marklogic.hub.entity.PropertyType;
import com.marklogic.hub.error.DataHubProjectException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class EntityManagerImpl
extends LoggingObject
implements EntityManager {
    public static final String ENTITY_FILE_EXTENSION = ".entity.json";
    @Autowired
    private HubConfig hubConfig;

    public EntityManagerImpl() {
    }

    public EntityManagerImpl(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
    }

    @Override
    public boolean saveQueryOptions() {
        QueryOptionsGenerator generator = new QueryOptionsGenerator(this.hubConfig.newStagingClient());
        try {
            String expOptions;
            Path dir = this.hubConfig.getHubProject().getEntityConfigDir();
            if (!dir.toFile().exists()) {
                dir.toFile().mkdirs();
            }
            File stagingFile = Paths.get(dir.toString(), "staging-entity-options.xml").toFile();
            File finalFile = Paths.get(dir.toString(), "final-entity-options.xml").toFile();
            File expStagingFile = Paths.get(dir.toString(), "exp-staging-entity-options.xml").toFile();
            File expFinalFile = Paths.get(dir.toString(), "exp-final-entity-options.xml").toFile();
            List<JsonNode> entities = this.getAllEntities();
            String options = generator.generateOptions(entities, false);
            if (options != null) {
                FileUtils.writeStringToFile((File)stagingFile, (String)options, (Charset)Charset.defaultCharset());
                this.logger.info("Wrote entity-specific search options to: " + stagingFile.getAbsolutePath());
                FileUtils.writeStringToFile((File)finalFile, (String)options, (Charset)Charset.defaultCharset());
                this.logger.info("Wrote entity-specific search options to: " + finalFile.getAbsolutePath());
            }
            if ((expOptions = generator.generateOptions(entities, true)) != null) {
                FileUtils.writeStringToFile((File)expStagingFile, (String)expOptions, (Charset)Charset.defaultCharset());
                this.logger.info("Wrote entity-specific search options for Explorer to: " + stagingFile.getAbsolutePath());
                FileUtils.writeStringToFile((File)expFinalFile, (String)expOptions, (Charset)Charset.defaultCharset());
                this.logger.info("Wrote entity-specific search options for Explorer to: " + finalFile.getAbsolutePath());
            }
            return options != null && expOptions != null;
        }
        catch (IOException e) {
            this.logger.warn("Unable to generate search options, cause: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public HashMap<Enum, Boolean> deployQueryOptions() {
        this.saveQueryOptions();
        HashMap<Enum, Boolean> loadedResources = new HashMap<Enum, Boolean>();
        if (this.deployQueryOptions(this.hubConfig.newFinalClient(), "final-entity-options.xml") && this.deployQueryOptions(this.hubConfig.newFinalClient(), "exp-final-entity-options.xml")) {
            loadedResources.put((Enum)DatabaseKind.FINAL, true);
        }
        if (this.deployQueryOptions(this.hubConfig.newStagingClient(), "staging-entity-options.xml") && this.deployQueryOptions(this.hubConfig.newStagingClient(), "exp-staging-entity-options.xml")) {
            loadedResources.put((Enum)DatabaseKind.STAGING, true);
        }
        return loadedResources;
    }

    private boolean deployQueryOptions(DatabaseClient client, String filename) {
        DefaultModulesLoader modulesLoader = new DefaultModulesLoader(new AssetFileLoader(this.hubConfig.newFinalClient()));
        boolean isLoaded = false;
        modulesLoader.setModulesManager(null);
        modulesLoader.setShutdownTaskExecutorAfterLoadingModules(false);
        AppConfig appConfig = this.hubConfig.getAppConfig();
        Path dir = this.hubConfig.getHubProject().getEntityConfigDir();
        File stagingFile = Paths.get(dir.toString(), filename).toFile();
        if (stagingFile.exists()) {
            modulesLoader.setDatabaseClient(client);
            modulesLoader.getAssetFileLoader().addDocumentFileProcessor((DocumentFileProcessor)new PermissionsDocumentFileProcessor(appConfig.getModulePermissions()));
            Resource r = modulesLoader.installQueryOptions((Resource)new FileSystemResource(stagingFile));
            if (r != null) {
                isLoaded = true;
            }
        }
        modulesLoader.setShutdownTaskExecutorAfterLoadingModules(true);
        modulesLoader.waitForTaskExecutorToFinish();
        return isLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveDbIndexes() {
        block7: {
            boolean bl;
            block8: {
                List<JsonNode> entities;
                Path dir = this.hubConfig.getEntityDatabaseDir();
                File finalFile = Paths.get(dir.toString(), "final-database.json").toFile();
                File stagingFile = Paths.get(dir.toString(), "staging-database.json").toFile();
                if (!dir.toFile().exists()) {
                    dir.toFile().mkdirs();
                }
                if ((entities = this.getAllEntities()).size() <= 0) break block7;
                DatabaseClient databaseClient = this.hubConfig.newStagingClient(null);
                try {
                    JsonNode modelArray = new ObjectMapper().valueToTree(entities);
                    ObjectNode indexNode = (ObjectNode)ModelsService.on(databaseClient).generateDatabaseProperties(modelArray);
                    ObjectMapper mapper = new ObjectMapper();
                    indexNode.put("database-name", "%%mlFinalDbName%%");
                    mapper.writerWithDefaultPrettyPrinter().writeValue(finalFile, (Object)indexNode);
                    indexNode.put("database-name", "%%mlStagingDbName%%");
                    mapper.writerWithDefaultPrettyPrinter().writeValue(stagingFile, (Object)indexNode);
                    bl = true;
                    if (databaseClient == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (databaseClient != null) {
                            databaseClient.release();
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.logger.error("Unable to generate database index files for entity properties; cause: " + e.getMessage(), (Throwable)e);
                    }
                }
                databaseClient.release();
            }
            return bl;
        }
        return false;
    }

    private List<JsonNode> getAllEntities() {
        ArrayList<JsonNode> entities = new ArrayList<JsonNode>(this.getAllLegacyEntities());
        Path entitiesPath = this.hubConfig.getHubEntitiesDir();
        File[] entityDefs = entitiesPath.toFile().listFiles(pathname -> pathname.toString().endsWith(ENTITY_FILE_EXTENSION) && !pathname.isHidden());
        if (entityDefs == null) {
            return entities;
        }
        Arrays.sort(entityDefs, new Comparator<File>(){

            @Override
            public int compare(File a, File b) {
                return a.getName().compareTo(b.getName());
            }
        });
        ObjectMapper objectMapper = new ObjectMapper();
        for (File entityDef : entityDefs) {
            try (FileInputStream fileInputStream = new FileInputStream(entityDef);){
                entities.add(objectMapper.readTree((InputStream)fileInputStream));
            }
            catch (IOException e) {
                this.logger.warn(this.format("Ignoring %s entity model as malformed JSON content is found", new Object[]{entityDef.getName()}));
                this.logger.error(e.getMessage());
            }
        }
        return entities;
    }

    private List<JsonNode> getAllLegacyEntities() {
        ArrayList<JsonNode> entities = new ArrayList<JsonNode>();
        Path entitiesPath = this.hubConfig.getHubProject().getLegacyHubEntitiesDir();
        File[] entityFiles = entitiesPath.toFile().listFiles(pathname -> pathname.isDirectory() && !pathname.isHidden());
        if (entityFiles != null) {
            List entityNames = Arrays.stream(entityFiles).map(file -> file.getName()).collect(Collectors.toList());
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                for (String entityName : entityNames) {
                    File[] entityDefs = entitiesPath.resolve(entityName).toFile().listFiles((dir, name) -> name.endsWith(ENTITY_FILE_EXTENSION));
                    if (entityDefs == null) continue;
                    for (File entityDef : entityDefs) {
                        try (FileInputStream fileInputStream = new FileInputStream(entityDef);){
                            entities.add(objectMapper.readTree((InputStream)fileInputStream));
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return entities;
    }

    @Override
    public HubEntity getEntityFromProject(String entityName) {
        return this.getEntityFromProject(entityName, null, Boolean.FALSE);
    }

    @Override
    public HubEntity getEntityFromProject(String entityName, String version) {
        return this.getEntityFromProject(entityName, version, Boolean.FALSE);
    }

    @Override
    public HubEntity getEntityFromProject(String entityName, Boolean extendSubEntities) {
        return this.getEntityFromProject(entityName, null, extendSubEntities);
    }

    @Override
    public HubEntity getEntityFromProject(String entityName, String version, Boolean extendSubEntities) {
        return this.getEntityFromProject(entityName, this.getEntities(), version, extendSubEntities);
    }

    public HubEntity getEntityFromProject(String entityName, List<HubEntity> modelFilesInProject, String version, Boolean extendSubEntities) {
        List<HubEntity> entityDefinitions = this.convertModelFilesToEntityDefinitions(modelFilesInProject);
        return this.getEntityFromEntityDefinitions(entityName, entityDefinitions, version, extendSubEntities);
    }

    protected HubEntity getEntityFromEntityDefinitions(String entityName, List<HubEntity> entityDefinitions, String version, Boolean extendSubEntities) {
        HubEntity entity = null;
        for (HubEntity e : entityDefinitions) {
            InfoType info = e.getInfo();
            if (!entityName.equals(info.getTitle()) || version != null && !version.equals(info.getVersion())) continue;
            entity = e;
            if (!extendSubEntities.booleanValue()) break;
            this.addSubProperties(entity, entityDefinitions, version);
            break;
        }
        return entity;
    }

    protected List<HubEntity> convertModelFilesToEntityDefinitions(List<HubEntity> modelFilesInProject) {
        ArrayList<HubEntity> flattenedModels = new ArrayList<HubEntity>();
        for (HubEntity model : modelFilesInProject) {
            Map<String, DefinitionType> map = model.getDefinitions().getDefinitions();
            for (Map.Entry<String, DefinitionType> entityEntry : map.entrySet()) {
                String entityTitle = entityEntry.getKey();
                InfoType newInfo = new InfoType();
                newInfo.setBaseUri(model.getInfo().getBaseUri());
                newInfo.setDescription(model.getInfo().getDescription());
                newInfo.setTitle(entityTitle);
                newInfo.setVersion(model.getInfo().getVersion());
                DefinitionsType definitionsType = new DefinitionsType();
                definitionsType.addDefinition(entityTitle, entityEntry.getValue());
                HubEntity newModel = new HubEntity();
                newModel.setFilename(model.getFilename());
                newModel.setInfo(newInfo);
                newModel.setDefinitions(definitionsType);
                flattenedModels.add(newModel);
            }
        }
        return flattenedModels;
    }

    protected void addSubProperties(HubEntity entity, List<HubEntity> entityDefinitions, String version) {
        Map<String, DefinitionType> definitions = entity.getDefinitions().getDefinitions();
        for (Map.Entry<String, DefinitionType> definitionEntry : definitions.entrySet()) {
            DefinitionType definition = definitionEntry.getValue();
            ArrayList<PropertyType> propertiesToRemove = new ArrayList<PropertyType>();
            for (PropertyType property : definition.getProperties()) {
                String ref = property.getRef();
                ItemType items = property.getItems();
                if (StringUtils.isEmpty((CharSequence)ref) && items != null) {
                    ref = items.getRef();
                }
                if (!StringUtils.isNotEmpty((CharSequence)ref)) continue;
                if (ref.startsWith("#/")) {
                    String subEntityName = ref.substring(ref.lastIndexOf(47) + 1);
                    HubEntity subEntity = this.getEntityFromEntityDefinitions(subEntityName, entityDefinitions, version, true);
                    if (subEntity == null) continue;
                    DefinitionType subDefinition = subEntity.getDefinitions().getDefinitions().get(subEntityName);
                    property.setSubProperties(subDefinition.getProperties());
                    continue;
                }
                propertiesToRemove.add(property);
            }
            if (propertiesToRemove.isEmpty()) continue;
            definition.getProperties().removeAll(propertiesToRemove);
        }
    }

    @Override
    public List<HubEntity> getEntities() {
        return this.getEntities(Boolean.FALSE);
    }

    @Override
    public List<HubEntity> getEntities(Boolean extendSubEntities) {
        ArrayList<HubEntity> entities = new ArrayList<HubEntity>();
        Path entitiesPath = this.hubConfig.getHubEntitiesDir();
        ObjectMapper objectMapper = new ObjectMapper();
        File[] entityDefs = entitiesPath.toFile().listFiles((dir, name) -> name.endsWith(ENTITY_FILE_EXTENSION));
        if (entityDefs != null) {
            for (File entityDef : entityDefs) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(entityDef);
                    JsonNode node = objectMapper.readTree((InputStream)fileInputStream);
                    entities.add(HubEntity.fromJson(entityDef.getAbsolutePath(), node));
                    fileInputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return entities;
    }

    @Override
    @Deprecated
    public HubEntity saveEntity(HubEntity entity, Boolean rename) throws IOException {
        JsonNode node = entity.toJson();
        ObjectMapper objectMapper = new ObjectMapper();
        String fullpath = entity.getFilename();
        String title = entity.getInfo().getTitle();
        if (rename.booleanValue()) {
            String filename = new File(fullpath).getName();
            int index = filename.indexOf(ENTITY_FILE_EXTENSION);
            if (index == -1) {
                throw new DataHubProjectException("Entity filename must end with file extension: .entity.json");
            }
            String entityFromFilename = filename.substring(0, index);
            if (!entityFromFilename.equals(title)) {
                File origFile = new File(fullpath);
                File newFile = new File(origFile.getParent() + File.separator + title + ENTITY_FILE_EXTENSION);
                if (!origFile.renameTo(newFile)) {
                    throw new IOException("Unable to rename " + origFile.getAbsolutePath() + " to " + newFile.getAbsolutePath());
                }
                fullpath = newFile.getAbsolutePath();
                entity.setFilename(fullpath);
                Path legacyEntitiesDir = this.hubConfig.getHubProject().getLegacyHubEntitiesDir();
                Path origLegacyEntityDir = legacyEntitiesDir.resolve(entityFromFilename);
                if (origLegacyEntityDir.toFile().exists()) {
                    Path newLegacyEntityDir = legacyEntitiesDir.resolve(title);
                    FileUtils.moveDirectory((File)origLegacyEntityDir.toFile(), (File)newLegacyEntityDir.toFile());
                }
            }
        } else {
            Path dir = this.hubConfig.getHubEntitiesDir();
            if (!dir.toFile().exists()) {
                dir.toFile().mkdirs();
            }
            fullpath = Paths.get(dir.toString(), title + ENTITY_FILE_EXTENSION).toString();
        }
        this.removeCollationFromEntityReferenceProperties(node);
        String json = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
        FileUtils.writeStringToFile((File)new File(fullpath), (String)json);
        return entity;
    }

    protected void removeCollationFromEntityReferenceProperties(JsonNode node) {
        if (node != null && node.has("definitions")) {
            JsonNode definitions = node.get("definitions");
            Iterator fieldNames = definitions.fieldNames();
            while (fieldNames.hasNext()) {
                JsonNode entity = definitions.get((String)fieldNames.next());
                if (!entity.has("properties")) continue;
                JsonNode properties = entity.get("properties");
                Iterator propertyNames = properties.fieldNames();
                while (propertyNames.hasNext()) {
                    JsonNode property = properties.get((String)propertyNames.next());
                    if (!property.has("$ref") || !property.has("collation")) continue;
                    ((ObjectNode)property).remove("collation");
                }
            }
        }
    }

    @Override
    public void deleteEntity(String entity) {
        Path entityPath = this.hubConfig.getHubEntitiesDir().resolve(entity + ENTITY_FILE_EXTENSION);
        if (entityPath.toFile().exists()) {
            entityPath.toFile().delete();
        }
    }

    @Override
    public boolean savePii() {
        try {
            Path protectedPaths = this.hubConfig.getUserSecurityDir().resolve("protected-paths");
            Path queryRolesets = this.hubConfig.getUserSecurityDir().resolve("query-rolesets");
            if (!protectedPaths.toFile().exists()) {
                protectedPaths.toFile().mkdirs();
            }
            if (!queryRolesets.toFile().exists()) {
                queryRolesets.toFile().mkdirs();
            }
            File queryRolesetsConfig = queryRolesets.resolve("pii-reader.json").toFile();
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
            List<JsonNode> entities = this.getAllEntities();
            if (entities.size() > 0) {
                ArrayNode models = mapper.createArrayNode();
                entities.forEach(model -> models.add(model));
                JsonNode v3ConfigAsJson = ModelsService.on(this.hubConfig.newStagingClient(null)).generateProtectedPathConfig((JsonNode)models);
                ArrayNode paths = (ArrayNode)v3ConfigAsJson.get("config").get("protected-path");
                int i = 0;
                for (JsonNode n : paths) {
                    String thisPath = String.format("%02d_%s", ++i, "pii-protected-paths.json");
                    File protectedPathConfig = protectedPaths.resolve(thisPath).toFile();
                    writer.writeValue(protectedPathConfig, (Object)n);
                }
                writer.writeValue(queryRolesetsConfig, (Object)v3ConfigAsJson.get("config").get("query-roleset"));
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to generate files for entity properties marked as PII; cause: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private static class QueryOptionsGenerator
    extends ResourceManager {
        QueryOptionsGenerator(DatabaseClient client) {
            client.init("mlSearchOptionsGenerator", (ResourceManager)this);
        }

        String generateOptions(List<JsonNode> entities, boolean forExplorer) {
            try {
                JsonNode node = new ObjectMapper().valueToTree(entities);
                RequestParameters params = new RequestParameters();
                params.put("forExplorer", Boolean.toString(forExplorer));
                return ((StringHandle)this.getServices().post(params, (AbstractWriteHandle)new JacksonHandle(node), (AbstractReadHandle)new StringHandle())).get();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unable to generate search options based on entity models", (Throwable)e);
                return null;
            }
        }
    }
}

