/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.marklogic.rest.util.Fragment;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Stream;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.FileCopyUtils;

class FinalDatabaseXmlFileUpgrader {
    static final String ES_PATH_NAMESPACE_PATH = "/m:database-properties/m:path-namespaces/m:path-namespace[m:prefix = 'es' and m:namespace-uri = 'http://marklogic.com/entity-services']";
    static final String DATA_HUB_RAN_STEP_FIELD_PATH = "/m:database-properties/m:fields/m:field[m:field-name = 'datahubRanBySteps']";
    static final String DATA_HUB_RAN_STEP_INDEX_PATH = "/m:database-properties/m:range-field-indexes/m:range-field-index[m:field-name = 'datahubRanBySteps']";
    static final String SOURCE_NAME_FIELD_PATH = "/m:database-properties/m:fields/m:field[m:field-name = 'datahubSourceName']";
    static final String SOURCE_TYPE_FIELD_PATH = "/m:database-properties/m:fields/m:field[m:field-name = 'datahubSourceType']";
    static final String SOURCE_NAME_INDEX_PATH = "/m:database-properties/m:range-field-indexes/m:range-field-index[m:field-name = 'datahubSourceName']";
    static final String SOURCE_TYPE_INDEX_PATH = "/m:database-properties/m:range-field-indexes/m:range-field-index[m:field-name = 'datahubSourceType']";
    static final String OLD_ACTION_DETAILS_INDEX_PATH = "/m:database-properties/m:range-path-indexes/m:range-path-index[m:path-expression = '//actionDetails/*/uris']";
    static final String NEW_ACTION_DETAILS_INDEX_PATH = "/m:database-properties/m:range-path-indexes/m:range-path-index[m:path-expression = '/matchSummary/actionDetails/*/uris']";

    FinalDatabaseXmlFileUpgrader() {
    }

    String updateFinalDatabaseXmlFile(String fileContents) {
        Fragment existingProps = new Fragment(fileContents, new Namespace[0]);
        Fragment officialProps = this.readOfficialFileFromClasspath();
        this.apply540Changes(existingProps, officialProps);
        return existingProps.getPrettyXml();
    }

    private void apply540Changes(Fragment existingProps, Fragment officialProps) {
        if (this.elementMissing(existingProps, ES_PATH_NAMESPACE_PATH)) {
            this.addEsPathNamespace(existingProps, officialProps);
        }
        Stream.of(SOURCE_NAME_FIELD_PATH, SOURCE_TYPE_FIELD_PATH, DATA_HUB_RAN_STEP_FIELD_PATH).forEach(path -> {
            if (this.elementMissing(existingProps, (String)path)) {
                this.addField(existingProps, ((Element)officialProps.getElements(path).get(0)).detach());
            }
        });
        Stream.of(SOURCE_NAME_INDEX_PATH, SOURCE_TYPE_INDEX_PATH, DATA_HUB_RAN_STEP_INDEX_PATH).forEach(path -> {
            if (this.elementMissing(existingProps, (String)path)) {
                this.addRangeFieldIndex(existingProps, ((Element)officialProps.getElements(path).get(0)).detach());
            }
        });
        Element oldActionDetailsIndex = this.getElement(existingProps, OLD_ACTION_DETAILS_INDEX_PATH);
        if (oldActionDetailsIndex != null) {
            oldActionDetailsIndex.detach();
        }
        if (this.elementMissing(existingProps, NEW_ACTION_DETAILS_INDEX_PATH)) {
            this.addRangePathIndex(existingProps, ((Element)officialProps.getElements(NEW_ACTION_DETAILS_INDEX_PATH).get(0)).detach());
        }
    }

    private Fragment readOfficialFileFromClasspath() {
        String path = "ml-config/database-fields/final-database.xml";
        try {
            String xml = new String(FileCopyUtils.copyToByteArray((InputStream)new ClassPathResource(path).getInputStream()), StandardCharsets.UTF_8);
            return new Fragment(xml, new Namespace[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to read from classpath file: " + path + "; cause: " + ex.getMessage(), ex);
        }
    }

    private boolean elementMissing(Fragment props, String xpath) {
        return props.getElements(xpath).isEmpty();
    }

    private void addEsPathNamespace(Fragment props, Fragment officialProps) {
        String namespacesPath = "/m:database-properties/m:path-namespaces";
        Element pathNamespaces = this.getElement(props, namespacesPath);
        if (pathNamespaces == null) {
            pathNamespaces = this.getElement(officialProps, namespacesPath).detach();
            props.getInternalDoc().getRootElement().getChildren().add(pathNamespaces);
        } else {
            Element esPathNamespace = this.getElement(officialProps, ES_PATH_NAMESPACE_PATH).detach();
            pathNamespaces.getChildren().add(esPathNamespace);
        }
    }

    private void addField(Fragment props, Element field) {
        this.getElement(props, "/m:database-properties/m:fields").getChildren().add(field);
    }

    private void addRangeFieldIndex(Fragment props, Element index) {
        this.getElement(props, "/m:database-properties/m:range-field-indexes").getChildren().add(index);
    }

    private void addRangePathIndex(Fragment props, Element index) {
        this.getElement(props, "/m:database-properties/m:range-path-indexes").getChildren().add(index);
    }

    private Element getElement(Fragment xml, String xpath) {
        List list = xml.getElements(xpath);
        return list.size() > 0 ? (Element)list.get(0) : null;
    }
}

