/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.EntityManager;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.MappingManager;
import com.marklogic.hub.entity.HubEntity;
import com.marklogic.hub.error.DataHubProjectException;
import com.marklogic.hub.impl.EntityManagerImpl;
import com.marklogic.hub.impl.Scaffolding;
import com.marklogic.hub.impl.ScaffoldingImpl;
import com.marklogic.hub.mapping.Mapping;
import com.marklogic.hub.mapping.MappingImpl;
import com.marklogic.hub.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MappingManagerImpl
extends LoggingObject
implements MappingManager {
    @Autowired
    protected HubConfig hubConfig;
    @Autowired
    private Scaffolding scaffolding;
    @Autowired
    private EntityManager entityManager;

    public MappingManagerImpl() {
    }

    public MappingManagerImpl(HubConfig hubConfig) {
        this.hubConfig = hubConfig;
        this.entityManager = new EntityManagerImpl(this.hubConfig);
        this.scaffolding = new ScaffoldingImpl(this.hubConfig);
    }

    @Override
    public Mapping createMapping(String mappingName) {
        return this.createMapping(mappingName, null);
    }

    @Override
    public Mapping createMapping(String mappingName, String entityName) {
        try {
            this.getMapping(mappingName);
            throw new DataHubProjectException("Mapping with that name already exists");
        }
        catch (Exception e) {
            if (entityName != null) {
                HubEntity entity = this.entityManager.getEntityFromProject(entityName);
                return Mapping.create(mappingName, entity);
            }
            return Mapping.create(mappingName);
        }
    }

    @Override
    public Mapping createMappingFromJSON(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = (JsonNode)mapper.readValue(json, JsonNode.class);
        return (Mapping)mapper.treeToValue((TreeNode)node, MappingImpl.class);
    }

    @Override
    public Mapping createMappingFromJSON(JsonNode json) {
        Mapping newMap = Mapping.create("default");
        newMap.deserialize(json);
        return newMap;
    }

    @Override
    public void deleteMapping(String mappingName) {
        Path dir = this.getMappingDirPath(mappingName);
        if (dir.toFile().exists()) {
            try {
                this.logger.info(this.format("Deleting mapping with name '%s' in directory: %s", new Object[]{mappingName, dir.toFile()}));
                FileUtils.deleteDirectory((File)dir.toFile());
            }
            catch (IOException e) {
                throw new DataHubProjectException(this.format("Could not delete mapping with name '%s'", new Object[]{mappingName}), e);
            }
        }
    }

    @Override
    public void saveMapping(Mapping mapping) {
        this.saveMapping(mapping, false);
    }

    @Override
    public void saveMapping(Mapping mapping, boolean autoIncrement) {
        this.scaffolding.createMappingDir(mapping.getName());
        try {
            if (autoIncrement) {
                mapping.incrementVersion();
            }
            String mappingString = mapping.serialize();
            Path dir = this.getMappingDirPath(mapping.getName());
            if (!dir.toFile().mkdirs() && !dir.toFile().exists()) {
                this.logger.error("Unable");
            }
            String mappingFileName = mapping.getName() + "-" + mapping.getVersion() + ".mapping.json";
            File file = Paths.get(dir.toString(), mappingFileName).toFile();
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            Object json = objectMapper.readValue(mappingString, Object.class);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(json).getBytes(StandardCharsets.UTF_8));
                fileOutputStream.flush();
            }
        }
        catch (JsonProcessingException e) {
            throw new DataHubProjectException("Could not serialize mapping for project.");
        }
        catch (IOException e) {
            throw new DataHubProjectException("Could not write mapping to disk for project.");
        }
    }

    @Override
    public ArrayList<String> getMappingsNames() {
        return (ArrayList)FileUtil.listDirectFolders(this.hubConfig.getHubMappingsDir().toFile());
    }

    @Override
    public ArrayList<Mapping> getMappings() {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        ArrayList<String> mappingNames = this.getMappingsNames();
        for (String mappingName : mappingNames) {
            Mapping newMap = this.getMappingVersion(mappingName);
            if (newMap == null) continue;
            mappings.add(newMap);
        }
        return mappings;
    }

    private Mapping getMappingVersion(String mappingName) {
        return this.getMappingVersion(mappingName, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Mapping getMappingVersion(String mappingName, int version) {
        int mappingExtensionCount = ".mapping.json".length();
        Path mappingPath = Paths.get(this.hubConfig.getHubMappingsDir().toString(), mappingName);
        List<String> fileNames = FileUtil.listDirectFiles(mappingPath);
        String targetFileName = null;
        int highestVersion = -1;
        for (String fileName : fileNames) {
            if (!fileName.substring(0, mappingName.length()).equalsIgnoreCase(mappingName.toLowerCase()) || !fileName.substring(fileName.length() - mappingExtensionCount).equalsIgnoreCase(".mapping.json")) continue;
            String parsedFileNameVersion = fileName.replaceAll(".+\\-([0-9]+)\\.mapping\\.json", "$1");
            int fileNameVersion = Integer.parseInt(parsedFileNameVersion);
            if (version == -1 && fileNameVersion > highestVersion) {
                highestVersion = fileNameVersion;
                targetFileName = fileName;
                continue;
            }
            if (version == -1 || fileNameVersion != version) continue;
            targetFileName = fileName;
            break;
        }
        if (targetFileName == null) return null;
        try (FileInputStream fileInputStream = new FileInputStream(mappingPath.resolve(targetFileName).toFile());){
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode node = objectMapper.readTree((InputStream)fileInputStream);
            Mapping newMap = this.createMappingFromJSON(node);
            if (newMap == null) return null;
            if (newMap.getName().length() <= 0) return null;
            Mapping mapping = newMap;
            return mapping;
        }
        catch (IOException e) {
            throw new DataHubProjectException("Could not read mapping on disk.");
        }
    }

    @Override
    public Mapping getMapping(String mappingName) {
        Mapping foundMap = this.getMappingVersion(mappingName);
        if (foundMap != null) {
            return foundMap;
        }
        throw new DataHubProjectException("Mapping not found in project: " + mappingName);
    }

    @Override
    public Mapping getMapping(String mappingName, int version, boolean createIfNotExisted) {
        Mapping foundMap = this.getMappingVersion(mappingName, version);
        if (foundMap != null) {
            return foundMap;
        }
        if (createIfNotExisted) {
            return Mapping.create(mappingName);
        }
        throw new DataHubProjectException("Mapping not found in project: " + mappingName);
    }

    @Override
    public String getMappingAsJSON(String mappingName) {
        Mapping mapping = this.getMapping(mappingName);
        String jsonMap = null;
        if (mapping != null) {
            jsonMap = mapping.serialize();
        }
        return jsonMap;
    }

    @Override
    public String getMappingAsJSON(String mappingName, int version, boolean createIfNotExisted) {
        Mapping mapping = this.getMapping(mappingName, version, createIfNotExisted);
        String jsonMap = null;
        if (mapping != null) {
            jsonMap = mapping.serialize();
        }
        return jsonMap;
    }

    private Path getMappingDirPath(String mappingName) {
        return Paths.get(this.hubConfig.getHubMappingsDir().toString(), mappingName);
    }
}

