/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.legacy.collector;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiskQueue<E extends Serializable>
extends AbstractQueue<String>
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(DiskQueue.class.getName());
    private static final float DEFAULT_REFILL_RATIO = 0.75f;
    private MemoryQueue<String> memoryQueue;
    private Iterator<String> memoryIterator;
    private float refillMemoryRatio;
    private int fileElementCount = 0;
    private File tempDir;
    private BufferedWriter fileOut;
    private BufferedReader fileIn;
    private String cachedElement;
    private File fileQueue;

    private static int safeIntCast(float f) {
        if (f > 2.1474836E9f) {
            return 0x7FFFFFFE;
        }
        return (int)f;
    }

    public DiskQueue() {
        this(DiskQueue.safeIntCast((float)Runtime.getRuntime().freeMemory() / 40.0f * 0.75f), null);
    }

    public DiskQueue(int maxInMemorySize) {
        this(maxInMemorySize, null);
    }

    public DiskQueue(int maxInMemorySize, File tempDir) {
        if (maxInMemorySize < 1) {
            throw new InvalidParameterException(DiskQueue.class.getSimpleName() + " max in-memory size must be at least one");
        }
        if (!(tempDir == null || tempDir.exists() && tempDir.isDirectory() && tempDir.canWrite())) {
            throw new InvalidParameterException(DiskQueue.class.getSimpleName() + " temporary directory must exist and be writable");
        }
        this.tempDir = tempDir;
        this.memoryQueue = new MemoryQueue(maxInMemorySize);
        this.refillMemoryRatio = 0.75f;
    }

    @Override
    public void close() {
        if (this.closeFile()) {
            LOG.warning(MessageFormat.format("{0} still had open file", DiskQueue.class.getSimpleName()));
        }
    }

    private boolean closeFile() {
        if (this.fileQueue == null) {
            return false;
        }
        DiskQueue.closeQuietly(this.fileIn);
        this.fileIn = null;
        this.cachedElement = null;
        DiskQueue.closeQuietly(this.fileOut);
        this.fileOut = null;
        this.fileElementCount = 0;
        if (!this.fileQueue.delete()) {
            LOG.log(Level.INFO, "Unable to clean up file queue located at " + this.fileQueue.getAbsolutePath());
        }
        this.fileQueue = null;
        return true;
    }

    private static boolean isEmpty(CharSequence value) {
        return value == null || value.length() == 0;
    }

    private static void closeQuietly(Closeable obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void openFile() throws IOException {
        if (this.fileQueue == null) {
            this.fileQueue = File.createTempFile(DiskQueue.class.getSimpleName() + "-backingstore-", null, this.tempDir);
            this.fileQueue.deleteOnExit();
            LOG.log(Level.INFO, "created backing store {0}", this.fileQueue.getAbsolutePath());
            this.fileOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileQueue), StandardCharsets.UTF_8));
            this.fileOut.flush();
            this.fileIn = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileQueue), "UTF8"));
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.memoryQueue.size() + this.fileElementCount + (this.cachedElement != null ? 1 : 0);
    }

    @Override
    public boolean offer(String element) {
        if (element == null) {
            throw new NullPointerException("Element cannot be null for AbstractQueue");
        }
        boolean hasFileQueue = this.fileQueue != null;
        boolean offerRejected = false;
        if (!hasFileQueue) {
            boolean bl = offerRejected = !this.memoryQueue.offer(element);
            if (offerRejected) {
                this.memoryIterator = this.memoryQueue.iterator();
            }
        }
        if (hasFileQueue || offerRejected) {
            try {
                this.openFile();
                this.fileOut.write(element);
                this.fileOut.newLine();
                ++this.fileElementCount;
            }
            catch (IOException e) {
                LOG.severe(MessageFormat.format("Error writing to {0} backing store", DiskQueue.class.getSimpleName()));
                return false;
            }
        }
        return true;
    }

    @Override
    public String peek() {
        this.loadMemoryQueue();
        return this.memoryQueue.peek();
    }

    @Override
    public String remove() {
        this.loadMemoryQueue();
        return this.memoryQueue.remove();
    }

    @Override
    public String poll() {
        this.loadMemoryQueue();
        return this.memoryQueue.poll();
    }

    @Override
    public void clear() {
        this.memoryQueue.clear();
        this.cachedElement = null;
        this.closeFile();
    }

    private void loadMemoryQueue() {
        if ((float)this.memoryQueue.size() / (float)this.memoryQueue.getCapacity() >= this.refillMemoryRatio) {
            return;
        }
        if (this.cachedElement != null && this.memoryQueue.offer(this.cachedElement)) {
            this.cachedElement = null;
        }
        if (this.fileQueue != null) {
            try {
                this.fileOut.flush();
                int usedCount = 0;
                while (this.fileElementCount > 0) {
                    String nextFileElement = this.fileIn.readLine();
                    --this.fileElementCount;
                    ++usedCount;
                    if (DiskQueue.isEmpty(nextFileElement) || this.memoryQueue.offer(nextFileElement)) continue;
                    this.cachedElement = nextFileElement;
                    this.memoryIterator = this.memoryQueue.iterator();
                    return;
                }
                this.memoryIterator = this.memoryQueue.iterator();
                this.closeFile();
            }
            catch (IOException e) {
                LOG.severe(MessageFormat.format("Error reading from {0} backing store", DiskQueue.class.getSimpleName()));
            }
        }
    }

    private static class MemoryQueue<E>
    extends AbstractQueue<String> {
        private final Deque<String> queue;
        private final int capacity;

        public MemoryQueue(int capacity) {
            this.capacity = capacity;
            this.queue = new ArrayDeque<String>(10000);
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return this.queue.iterator();
        }

        public int getCapacity() {
            return this.capacity;
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public boolean offer(String o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (this.queue.size() >= this.capacity) {
                return false;
            }
            this.queue.add(o);
            return true;
        }

        @Override
        public String peek() {
            if (this.queue.isEmpty()) {
                return null;
            }
            return this.queue.peek();
        }

        @Override
        public String poll() {
            if (this.queue.isEmpty()) {
                return null;
            }
            return this.queue.poll();
        }

        @Override
        public String remove() {
            return this.queue.remove();
        }
    }

    private class Itr
    implements Iterator<String> {
        public Itr() {
            DiskQueue.this.memoryIterator = DiskQueue.this.memoryQueue.iterator();
        }

        @Override
        public boolean hasNext() {
            return DiskQueue.this.memoryIterator.hasNext() || DiskQueue.this.fileElementCount > 0 || DiskQueue.this.cachedElement != null;
        }

        @Override
        public String next() {
            String next = (String)DiskQueue.this.memoryIterator.next();
            if (!(DiskQueue.this.memoryIterator.hasNext() || DiskQueue.this.fileElementCount <= 0 && DiskQueue.this.cachedElement == null)) {
                DiskQueue.this.memoryQueue.clear();
                DiskQueue.this.loadMemoryQueue();
            }
            return next;
        }

        @Override
        public void remove() {
            DiskQueue.this.memoryIterator.remove();
        }
    }
}

