/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.legacy.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.extensions.ResourceManager;
import com.marklogic.client.extensions.ResourceServices;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.util.RequestParameters;
import com.marklogic.hub.legacy.LegacyFlowManager;
import com.marklogic.hub.legacy.flow.FlowType;
import com.marklogic.hub.legacy.flow.LegacyFlow;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FlowResource
extends ResourceManager {
    public FlowResource(DatabaseClient client) {
        client.init("mlFlow", (ResourceManager)this);
    }

    public List<LegacyFlow> getFlows(String entityName) {
        DOMHandle handle;
        RequestParameters params = new RequestParameters();
        params.add("entity-name", entityName);
        ResourceServices.ServiceResultIterator resultItr = this.getServices().get(params, new String[0]);
        if (resultItr == null || !resultItr.hasNext()) {
            return null;
        }
        ResourceServices.ServiceResult res = (ResourceServices.ServiceResult)resultItr.next();
        Document parent = ((DOMHandle)res.getContent((AbstractReadHandle)(handle = new DOMHandle()))).get();
        NodeList children = parent.getDocumentElement().getChildNodes();
        if (children.getLength() <= 0) {
            return null;
        }
        ArrayList<LegacyFlow> flows = new ArrayList<LegacyFlow>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            flows.add(LegacyFlowManager.flowFromXml((Element)children.item(i)));
        }
        return flows;
    }

    public LegacyFlow getFlow(String entityName, String flowName, FlowType flowType) {
        ResourceServices.ServiceResultIterator resultItr;
        RequestParameters params = new RequestParameters();
        params.add("entity-name", entityName);
        params.add("flow-name", flowName);
        if (flowType != null) {
            params.add("flow-type", flowType.toString());
        }
        if ((resultItr = this.getServices().get(params, new String[0])) == null || !resultItr.hasNext()) {
            return null;
        }
        ResourceServices.ServiceResult res = (ResourceServices.ServiceResult)resultItr.next();
        DOMHandle handle = new DOMHandle();
        Document parent = ((DOMHandle)res.getContent((AbstractReadHandle)handle)).get();
        return LegacyFlowManager.flowFromXml(parent.getDocumentElement());
    }
}

