/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.legacy.job.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.Transaction;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.ExportListener;
import com.marklogic.client.datamovement.JobReport;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.datamovement.WriteBatcher;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.JSONDocumentManager;
import com.marklogic.client.ext.datamovement.consumer.WriteToZipConsumer;
import com.marklogic.client.extensions.ResourceManager;
import com.marklogic.client.extensions.ResourceServices;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.JacksonDatabindHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.client.query.QueryManager;
import com.marklogic.client.query.StructuredQueryBuilder;
import com.marklogic.client.query.StructuredQueryDefinition;
import com.marklogic.client.util.RequestParameters;
import com.marklogic.hub.legacy.job.Job;
import com.marklogic.hub.legacy.job.JobDeleteResponse;
import com.marklogic.hub.legacy.job.JobExportResponse;
import com.marklogic.hub.legacy.job.LegacyJobManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;

public class LegacyJobManagerImpl
implements LegacyJobManager {
    private DatabaseClient jobClient;
    private JSONDocumentManager docMgr;
    private JobDeleteResource jobDeleteRunner = null;
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static SimpleDateFormat simpleDateFormat8601;
    private ObjectMapper objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false).configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setDateFormat((DateFormat)simpleDateFormat8601);

    public LegacyJobManagerImpl(DatabaseClient jobClient) {
        this.jobClient = jobClient;
        this.docMgr = jobClient.newJSONDocumentManager();
        this.jobDeleteRunner = new JobDeleteResource(jobClient);
    }

    @Override
    public void saveJob(Job job) {
        this.saveJob(job, null);
    }

    @Override
    public void saveJob(Job job, Transaction transaction) {
        JacksonDatabindHandle contentHandle = new JacksonDatabindHandle((Object)job);
        contentHandle.setMapper(this.objectMapper);
        DocumentMetadataHandle metadataHandle = new DocumentMetadataHandle();
        metadataHandle = metadataHandle.withCollections(new String[]{"job"});
        DocumentWriteSet writeSet = this.docMgr.newWriteSet();
        writeSet.add("/jobs/" + job.getJobId() + ".json", (DocumentMetadataWriteHandle)metadataHandle, (AbstractWriteHandle)contentHandle);
        this.docMgr.write(writeSet, transaction);
    }

    @Override
    public JobDeleteResponse deleteJobs(String jobIds) {
        return this.jobDeleteRunner.deleteJobs(jobIds);
    }

    @Override
    public JobExportResponse exportJobs(Path exportFilePath, String[] jobIds) {
        JobExportResponse response = new JobExportResponse();
        response.fullPath = exportFilePath.toAbsolutePath().toString();
        File zipFile = exportFilePath.toFile();
        try (WriteToZipConsumer zipConsumer = new WriteToZipConsumer(zipFile);){
            long jobCount;
            QueryManager qm = this.jobClient.newQueryManager();
            StructuredQueryBuilder sqb = qm.newStructuredQueryBuilder();
            DataMovementManager dmm = this.jobClient.newDataMovementManager();
            StructuredQueryDefinition query = jobIds == null ? null : sqb.value((StructuredQueryBuilder.TextIndex)sqb.jsonProperty("jobId"), jobIds);
            QueryBatcher batcher = this.newQueryBatcher(dmm, this.jobClient, query);
            batcher.onUrisReady((QueryBatchListener)new ExportListener().onDocumentReady((Consumer)zipConsumer));
            JobTicket jobTicket = dmm.startJob(batcher);
            batcher.awaitCompletion();
            dmm.stopJob((Batcher)batcher);
            dmm.release();
            JobReport report = dmm.getJobReport(jobTicket);
            response.totalJobs = jobCount = report.getSuccessEventsCount();
            if (jobCount > 0L) {
                long traceCount;
                dmm = this.jobClient.newDataMovementManager();
                query = jobIds == null ? null : sqb.value((StructuredQueryBuilder.TextIndex)sqb.element(new QName("jobId")), jobIds);
                batcher = this.newQueryBatcher(dmm, this.jobClient, query);
                batcher.onUrisReady((QueryBatchListener)new ExportListener().onDocumentReady((Consumer)zipConsumer));
                jobTicket = dmm.startJob(batcher);
                batcher.awaitCompletion();
                dmm.stopJob((Batcher)batcher);
                dmm.release();
                report = dmm.getJobReport(jobTicket);
                response.totalTraces = traceCount = report.getSuccessEventsCount();
            } else {
                zipConsumer.close();
                zipFile.delete();
            }
        }
        return response;
    }

    private QueryBatcher newQueryBatcher(DataMovementManager dmm, DatabaseClient client, StructuredQueryDefinition query) {
        QueryBatcher queryBatcher = null;
        queryBatcher = query == null ? dmm.newQueryBatcher(client.newQueryManager().newRawCtsQueryDefinition((CtsQueryWriteHandle)new StringHandle("<cts:true-query xmlns:cts=\"http://marklogic.com/cts\"/>").withFormat(Format.XML))) : dmm.newQueryBatcher(query);
        queryBatcher.withConsistentSnapshot().withBatchSize(100).withThreadCount(16);
        return queryBatcher;
    }

    @Override
    public void importJobs(Path importFilePath) throws IOException {
        try (ZipFile importZip = new ZipFile(importFilePath.toFile());){
            Enumeration<? extends ZipEntry> entries = importZip.entries();
            DataMovementManager dmm = this.jobClient.newDataMovementManager();
            WriteBatcher writer = dmm.newWriteBatcher().withJobName("Load jobs").withBatchSize(50);
            JobTicket ticket = dmm.startJob(writer);
            ArrayList<ZipEntry> traceEntries = new ArrayList<ZipEntry>();
            DocumentMetadataHandle jobMetadata = new DocumentMetadataHandle().withCollections(new String[]{"job"});
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getName().startsWith("/jobs/")) {
                    Scanner s = new Scanner(importZip.getInputStream(entry), StandardCharsets.UTF_8.name()).useDelimiter("\\A");
                    String entryText = s.hasNext() ? s.next() : "";
                    writer.add(entry.getName(), (DocumentMetadataWriteHandle)jobMetadata, (AbstractWriteHandle)new StringHandle(entryText).withFormat(Format.JSON));
                    continue;
                }
                traceEntries.add(entry);
            }
            writer.flushAndWait();
            dmm.stopJob(ticket);
            dmm.release();
            if (traceEntries.size() > 0) {
                dmm = this.jobClient.newDataMovementManager();
                writer = dmm.newWriteBatcher().withJobName("Load traces");
                ticket = dmm.startJob(writer);
                DocumentMetadataHandle traceMetadata = new DocumentMetadataHandle().withCollections(new String[]{"trace"});
                for (ZipEntry entry : traceEntries) {
                    Scanner s = new Scanner(importZip.getInputStream(entry), StandardCharsets.UTF_8.name()).useDelimiter("\\A");
                    String entryText = s.hasNext() ? s.next() : "";
                    writer.add(entry.getName(), (DocumentMetadataWriteHandle)traceMetadata, (AbstractWriteHandle)new StringHandle(entryText).withFormat(entry.getName().endsWith(".json") ? Format.JSON : Format.XML));
                }
                writer.flushAndWait();
                dmm.stopJob(ticket);
                dmm.release();
            }
        }
    }

    static {
        block2: {
            try {
                simpleDateFormat8601 = new SimpleDateFormat(ISO_8601_FORMAT);
            }
            catch (IllegalArgumentException e) {
                if (!"Illegal pattern character 'X'".equals(e.getMessage())) break block2;
                simpleDateFormat8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            }
        }
        simpleDateFormat8601.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static class JobDeleteResource
    extends ResourceManager {
        private static final String DELETE_SERVICE = "mlDeleteJobs";
        private DatabaseClient srcClient;

        public JobDeleteResource(DatabaseClient srcClient) {
            this.srcClient = srcClient;
            this.srcClient.init(DELETE_SERVICE, (ResourceManager)this);
        }

        public JobDeleteResponse deleteJobs(String jobIds) {
            JobDeleteResponse resp = null;
            try {
                RequestParameters params = new RequestParameters();
                params.add("jobIds", jobIds);
                ResourceServices services = this.getServices();
                ResourceServices.ServiceResultIterator resultItr = services.post(params, (AbstractWriteHandle)new StringHandle("{}").withFormat(Format.JSON), new String[0]);
                if (resultItr == null || !resultItr.hasNext()) {
                    resp = new JobDeleteResponse();
                } else {
                    ResourceServices.ServiceResult res = (ResourceServices.ServiceResult)resultItr.next();
                    StringHandle handle = new StringHandle();
                    ObjectMapper objectMapper = new ObjectMapper();
                    resp = (JobDeleteResponse)objectMapper.readValue(((StringHandle)res.getContent((AbstractReadHandle)handle)).get(), JobDeleteResponse.class);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return resp;
        }
    }
}

