/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.provenance;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.dataservices.BulkUtil;

public class ProvenanceManager {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final HubClient hubClient;

    public ProvenanceManager(HubClient hubClient) {
        this.hubClient = hubClient;
    }

    public void deleteProvenanceRecords(String retainDuration) {
        this.deleteProvenanceRecords(retainDuration, DatabaseKind.JOB.name());
    }

    public void deleteProvenanceRecords(String retainDuration, String database) {
        String apiPath = "ml-modules/root/data-hub/5/data-services/provenance/deleteProvenance.api";
        DatabaseKind databaseKind = DatabaseKind.valueOf((String)database);
        DatabaseClient client = null;
        switch (databaseKind) {
            case JOB: {
                client = this.hubClient.getJobsClient();
                break;
            }
            case STAGING: {
                client = this.hubClient.getStagingClient();
                break;
            }
            case FINAL: {
                client = this.hubClient.getFinalClient();
                break;
            }
            default: {
                throw new RuntimeException("Invalid provenance database: " + database);
            }
        }
        BulkUtil.deleteData(client, apiPath, retainDuration);
    }

    public void migrateProvenanceRecords() {
        String apiPath = "ml-modules/root/data-hub/5/data-services/provenance/migrateProvenance.api";
        ObjectNode endpointConstants = objectMapper.createObjectNode().put("batchSize", 250);
        BulkUtil.runExecCaller(this.hubClient.getJobsClient(), apiPath, endpointConstants, "Unable to migrate provenance, cause: ");
    }
}

