/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.step;

import com.fasterxml.jackson.databind.node.TextNode;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.impl.StepDefinitionManagerImpl;
import com.marklogic.hub.step.MarkLogicStepDefinitionProvider;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.hub.step.StepDefinitionProvider;
import com.marklogic.hub.step.StepRunner;
import com.marklogic.hub.step.impl.QueryStepRunner;
import com.marklogic.hub.step.impl.Step;
import com.marklogic.hub.step.impl.WriteStepRunner;
import java.util.Map;
import java.util.Optional;

public class StepRunnerFactory {
    private HubClient hubClient;
    private HubProject hubProject;
    private StepDefinitionProvider stepDefinitionProvider;

    public StepRunnerFactory(HubConfig hubConfig) {
        this.hubClient = hubConfig.newHubClient();
        this.hubProject = hubConfig.getHubProject();
        this.stepDefinitionProvider = new StepDefinitionManagerImpl(this.hubClient, hubConfig.getHubProject());
    }

    public StepRunnerFactory(HubClient hubClient) {
        this.hubClient = hubClient;
        this.stepDefinitionProvider = new MarkLogicStepDefinitionProvider(hubClient.getStagingClient());
    }

    public StepRunner getStepRunner(Flow flow, String stepNum) {
        Map<String, Step> steps = flow.getSteps();
        Step step = steps.get(stepNum);
        StepDefinition stepDef = this.stepDefinitionProvider.getStepDefinition(step.getStepDefinitionName(), step.getStepDefinitionType());
        StepRunner stepRunner = StepDefinition.StepDefinitionType.INGESTION.equals((Object)step.getStepDefinitionType()) ? new WriteStepRunner(this.hubClient, this.hubProject) : new QueryStepRunner(this.hubClient);
        stepRunner = stepRunner.withFlow(flow).withStep(stepNum);
        int batchSize = 100;
        if (Optional.ofNullable(step.getBatchSize()).orElse(0) != 0) {
            batchSize = step.getBatchSize();
        } else if (flow.getBatchSize() != 0) {
            batchSize = flow.getBatchSize();
        } else if (stepDef != null && stepDef.getBatchSize() != 0) {
            batchSize = stepDef.getBatchSize();
        }
        stepRunner.withBatchSize(batchSize);
        int threadCount = 4;
        if (Optional.ofNullable(step.getThreadCount()).orElse(0) != 0) {
            threadCount = step.getThreadCount();
        } else if (flow.getThreadCount() != 0) {
            threadCount = flow.getThreadCount();
        } else if (stepDef != null && stepDef.getThreadCount() != 0) {
            threadCount = stepDef.getThreadCount();
        }
        stepRunner.withThreadCount(threadCount);
        if (stepRunner instanceof WriteStepRunner) {
            String targetDatabase = step.getOptions().get("targetDatabase") != null ? ((TextNode)step.getOptions().get("targetDatabase")).asText() : (stepDef.getOptions().get("targetDatabase") != null ? ((TextNode)stepDef.getOptions().get("targetDatabase")).asText() : (StepDefinition.StepDefinitionType.INGESTION.equals((Object)step.getStepDefinitionType()) ? this.hubClient.getDbName(DatabaseKind.STAGING) : this.hubClient.getDbName(DatabaseKind.FINAL)));
            ((WriteStepRunner)stepRunner).withDestinationDatabase(targetDatabase);
        }
        if (StepDefinition.StepDefinitionType.INGESTION.equals((Object)step.getStepDefinitionType())) {
            ((WriteStepRunner)stepRunner).withStepDefinition(stepDef);
        }
        return stepRunner;
    }
}

