/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.step.impl;

import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.util.DiskQueue;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;

public class FileCollector
extends LoggingObject {
    private String inputFormat;
    private Set<String> textExts = new HashSet<String>(Arrays.asList("txt"));
    private Set<String> jsonExts = new HashSet<String>(Arrays.asList("json"));
    private Set<String> csvExts = new HashSet<String>(Arrays.asList("txt", "csv", "tsv", "psv"));
    private Set<String> xmlExts = new HashSet<String>(Arrays.asList("xml", "xhtml", "html"));
    private Map<String, Set<String>> fileFormats;

    public FileCollector(String inputFormat) {
        this.inputFormat = inputFormat.toLowerCase();
        this.fileFormats = new HashMap<String, Set<String>>();
        this.fileFormats.put("text", this.textExts);
        this.fileFormats.put("json", this.jsonExts);
        this.fileFormats.put("csv", this.csvExts);
        this.fileFormats.put("xml", this.xmlExts);
    }

    public DiskQueue<String> run(Path dirPath) {
        DiskQueue<String> results;
        if (!Files.exists(dirPath, new LinkOption[0]) || !Files.isDirectory(dirPath, new LinkOption[0])) {
            throw new RuntimeException("The path doesn't exist or is not a directory: " + dirPath);
        }
        try {
            results = new DiskQueue<String>();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Finding files in directory: " + dirPath);
            }
            try (Stream<Path> files = Files.find(dirPath, Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]);){
                files.forEach(path -> {
                    File file = path.toFile();
                    if (this.acceptFile(file.getName())) {
                        results.add(file.getAbsolutePath());
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return results;
    }

    protected boolean acceptFile(String filename) {
        if (filename == null) {
            return false;
        }
        String fileExtension = FilenameUtils.getExtension((String)filename).toLowerCase();
        if (fileExtension.trim().length() == 0 && ("json".equals(this.inputFormat) || "xml".equals(this.inputFormat))) {
            return true;
        }
        if (this.fileFormats.containsKey(this.inputFormat) && this.fileFormats.get(this.inputFormat).contains(fileExtension)) {
            return true;
        }
        return "binary".equals(this.inputFormat) && !this.csvExts.contains(fileExtension) && !this.jsonExts.contains(fileExtension) && !this.xmlExts.contains(fileExtension);
    }
}

