/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.util.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.marklogic.hub.util.json.JSONObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class JSONUtils {
    public static void trimText(JSONObject jsonObject, String ... excludeFields) {
        JSONUtils.trimText(jsonObject.json, excludeFields);
    }

    public static void trimText(JsonNode jsonNode, String ... excludeFields) {
        jsonNode.fields().forEachRemaining(e -> JSONUtils.processJson(jsonNode, (String)e.getKey(), (JsonNode)e.getValue(), excludeFields));
    }

    private static void processJson(JsonNode parent, String key, JsonNode value, String ... excludeFields) {
        if (ArrayUtils.contains((Object[])excludeFields, (Object)key)) {
            return;
        }
        if (value.isTextual()) {
            ((ObjectNode)parent).put(key, StringUtils.trim((String)value.asText()));
        } else if (value.isArray()) {
            for (int i = 0; i < value.size(); ++i) {
                if (value.get(i).isTextual()) {
                    ((ArrayNode)parent.withArray(key)).set(i, (JsonNode)new TextNode(StringUtils.trim((String)value.get(i).asText())));
                    continue;
                }
                if (value.get(i).isArray()) {
                    JSONUtils.processArray(parent.withArray(key).get(i), i, value.get(i), excludeFields);
                    continue;
                }
                if (!value.get(i).isObject()) continue;
                JsonNode val = value.get(i);
                val.fields().forEachRemaining(e -> JSONUtils.processJson(val, (String)e.getKey(), (JsonNode)e.getValue(), excludeFields));
            }
        } else if (value.isObject()) {
            value.fields().forEachRemaining(e -> JSONUtils.processJson(value, (String)e.getKey(), (JsonNode)e.getValue(), excludeFields));
        }
    }

    private static void processArray(JsonNode parent, int index, JsonNode value, String ... excludeFields) {
        if (value.isTextual()) {
            ((ArrayNode)parent).set(index, (JsonNode)new TextNode(StringUtils.trim((String)value.asText())));
        } else if (value.isArray()) {
            for (int i = 0; i < value.size(); ++i) {
                if (value.get(i).isArray()) {
                    for (int j = 0; j < value.size(); ++j) {
                        JSONUtils.processArray(parent.get(j), j, value.get(j), excludeFields);
                    }
                    continue;
                }
                JSONUtils.processArray(parent, i, value.get(i), excludeFields);
            }
        } else if (value.isObject()) {
            value.fields().forEachRemaining(e -> JSONUtils.processJson(value, (String)e.getKey(), (JsonNode)e.getValue(), excludeFields));
        }
    }

    public static JsonNode convertArtifactToJson(Object artifact) {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.valueToTree(artifact);
    }
}

