/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement;

import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.ForestConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatcherConfig {
    public static final Integer DEFAULT_BATCH_SIZE = 100;
    public static final Integer DEFAULT_THREAD_COUNT = 8;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String jobName;
    private Integer batchSize = DEFAULT_BATCH_SIZE;
    private Integer threadCount = DEFAULT_THREAD_COUNT;
    private ForestConfiguration forestConfig;

    public void prepareBatcher(Batcher batcher) {
        if (this.jobName != null) {
            batcher.withJobName(this.jobName);
        }
        if (this.batchSize != null && this.batchSize > 0) {
            batcher.withBatchSize(this.batchSize.intValue());
        }
        if (this.threadCount != null && this.threadCount > 0) {
            batcher.withThreadCount(this.threadCount.intValue());
        }
        if (this.forestConfig != null) {
            batcher.withForestConfig(this.forestConfig);
        }
    }

    public String getJobName() {
        return this.jobName;
    }

    public BatcherConfig setJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public BatcherConfig setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Integer getThreadCount() {
        return this.threadCount;
    }

    public BatcherConfig setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public ForestConfiguration getForestConfig() {
        return this.forestConfig;
    }

    public BatcherConfig setForestConfig(ForestConfiguration forestConfig) {
        this.forestConfig = forestConfig;
        return this;
    }
}

