/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.job;

import com.marklogic.client.datamovement.DeleteListener;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.ext.datamovement.CollectionsQueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.QueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.job.AbstractQueryBatcherJob;
import java.util.Arrays;

public class DeleteCollectionsJob
extends AbstractQueryBatcherJob {
    private String[] collections;

    public DeleteCollectionsJob() {
        this.setRequireWhereProperty(false);
        this.addRequiredJobProperty("collections", "Comma-delimited list of collections to delete", value -> this.setCollections(value.split(",")));
    }

    public DeleteCollectionsJob(String ... collections) {
        this();
        this.setCollections(collections);
    }

    @Override
    protected QueryBatcherBuilder newQueryBatcherBuilder() {
        return new CollectionsQueryBatcherBuilder(this.collections);
    }

    @Override
    protected String getJobDescription() {
        return "Deleting collections: " + Arrays.asList(this.collections);
    }

    public void setCollections(String ... collections) {
        this.collections = collections;
        this.addUrisReadyListener((QueryBatchListener)new DeleteListener());
    }

    @Override
    protected void addWhereJobProperties() {
    }
}

