/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.job;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.ExportToWriterListener;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.ext.datamovement.QueryBatcherJobTicket;
import com.marklogic.client.ext.datamovement.job.AbstractQueryBatcherJob;
import com.marklogic.client.ext.datamovement.listener.XmlOutputListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class ExportToFileJob
extends AbstractQueryBatcherJob {
    private File exportFile;
    private String fileHeader;
    private String fileFooter;
    private FileWriter fileWriter;
    private ExportToWriterListener exportToWriterListener;
    private boolean includeXmlOutputListener = true;

    public ExportToFileJob() {
        this.addRequiredJobProperty("exportPath", "The path of the file to which selected records are exported", value -> this.setExportFile(new File((String)value)));
        this.addJobProperty("fileHeader", "Optional content that should be written to the start of each file", value -> this.setFileHeader((String)value));
        this.addJobProperty("fileFooter", "Optional content that should be written to the end of each file", value -> this.setFileFooter((String)value));
        this.addJobProperty("recordPrefix", "Optional content to be written before each record is written", value -> this.getExportListener().withRecordPrefix(value));
        this.addJobProperty("recordSuffix", "Optional content to be written after each record is written", value -> this.getExportListener().withRecordSuffix(value));
        this.addJobProperty("transform", "Optional REST transform to apply to each record before it is written", value -> this.getExportListener().withTransform(new ServerTransform(value)));
    }

    public ExportToFileJob(File exportFile) {
        this();
        this.setExportFile(exportFile);
    }

    public void setExportFile(File exportFile) {
        this.exportFile = exportFile;
        File parentFile = this.exportFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        try {
            this.fileWriter = new FileWriter(exportFile);
        }
        catch (IOException ie) {
            throw new RuntimeException("Unable to open FileWriter on file: " + exportFile + "; cause: " + ie.getMessage(), ie);
        }
        this.exportToWriterListener = new ExportToWriterListener((Writer)this.fileWriter);
        this.addUrisReadyListener((QueryBatchListener)this.exportToWriterListener);
    }

    @Override
    public QueryBatcherJobTicket run(DatabaseClient databaseClient) {
        QueryBatcherJobTicket ticket = super.run(databaseClient);
        if (ticket.getQueryBatcher().isStopped()) {
            try {
                if (this.fileFooter != null) {
                    this.fileWriter.write(this.fileFooter);
                }
            }
            catch (IOException ie) {
                throw new RuntimeException(ie);
            }
            finally {
                try {
                    this.fileWriter.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ticket;
    }

    @Override
    protected void prepareQueryBatcher(QueryBatcher queryBatcher) {
        super.prepareQueryBatcher(queryBatcher);
        if (this.includeXmlOutputListener) {
            this.exportToWriterListener.onGenerateOutput((ExportToWriterListener.OutputListener)new XmlOutputListener());
        }
        try {
            if (this.fileHeader != null) {
                this.fileWriter.write(this.fileHeader);
                this.fileWriter.write("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getJobDescription() {
        return "Exporting documents " + this.getQueryDescription() + " to file at: " + this.exportFile;
    }

    public FileWriter getFileWriter() {
        return this.fileWriter;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public ExportToWriterListener getExportListener() {
        return this.exportToWriterListener;
    }

    public void setFileHeader(String fileHeader) {
        this.fileHeader = fileHeader;
    }

    public void setFileFooter(String fileFooter) {
        this.fileFooter = fileFooter;
    }

    public void setIncludeXmlOutputListener(boolean includeXmlOutputListener) {
        this.includeXmlOutputListener = includeXmlOutputListener;
    }
}

