/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.listener;

import com.marklogic.client.datamovement.Batch;
import com.marklogic.client.datamovement.BatchFailureListener;
import com.marklogic.client.datamovement.ExportListener;
import com.marklogic.client.datamovement.QueryBatch;
import com.marklogic.client.document.DocumentManager;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.io.Format;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.LoggerFactory;

public abstract class AbstractExportBatchesListener
extends ExportListener {
    private String filenameExtension = "";
    private String filenamePrefix = "batch-";
    private ServerTransform transform;
    private Format nonDocumentFormat;
    private boolean consistentSnapshot;
    private Set<DocumentManager.Metadata> categories = new HashSet<DocumentManager.Metadata>();

    protected abstract void exportBatch(QueryBatch var1);

    public void processEvent(QueryBatch queryBatch) {
        try {
            this.exportBatch(queryBatch);
        }
        catch (Throwable t) {
            for (BatchFailureListener queryBatchFailureListener : this.getBatchFailureListeners()) {
                try {
                    queryBatchFailureListener.processFailure((Batch)queryBatch, t);
                }
                catch (Throwable t2) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Exception thrown by an onFailure listener", t2);
                }
            }
        }
    }

    protected File getFileForBatch(QueryBatch queryBatch, File exportDir) {
        String filename = queryBatch.getJobBatchNumber() + this.filenameExtension;
        if (this.filenamePrefix != null) {
            filename = this.filenamePrefix + filename;
        }
        return new File(exportDir, filename);
    }

    protected void prepareExportListener(ExportListener listener) {
        if (this.consistentSnapshot) {
            listener.withConsistentSnapshot();
        }
        if (this.categories != null) {
            for (DocumentManager.Metadata category : this.categories) {
                listener.withMetadataCategory(category);
            }
        }
        if (this.nonDocumentFormat != null) {
            listener.withNonDocumentFormat(this.nonDocumentFormat);
        }
        if (this.transform != null) {
            listener.withTransform(this.transform);
        }
    }

    public AbstractExportBatchesListener withFilenamePrefix(String filenamePrefix) {
        this.filenamePrefix = filenamePrefix;
        return this;
    }

    public AbstractExportBatchesListener withFilenameExtension(String filenameExtension) {
        this.filenameExtension = filenameExtension;
        return this;
    }

    public AbstractExportBatchesListener withConsistentSnapshot() {
        this.consistentSnapshot = true;
        return this;
    }

    public AbstractExportBatchesListener withMetadataCategory(DocumentManager.Metadata category) {
        this.categories.add(category);
        return this;
    }

    public AbstractExportBatchesListener withNonDocumentFormat(Format nonDocumentFormat) {
        this.nonDocumentFormat = nonDocumentFormat;
        return this;
    }

    public AbstractExportBatchesListener withTransform(ServerTransform transform) {
        this.transform = transform;
        return this;
    }
}

