/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.listener;

import com.marklogic.client.datamovement.ExportListener;
import com.marklogic.client.datamovement.QueryBatch;
import com.marklogic.client.ext.datamovement.consumer.WriteToZipConsumer;
import com.marklogic.client.ext.datamovement.listener.AbstractExportBatchesListener;
import java.io.File;
import java.util.function.Consumer;

public class ExportBatchesToZipsListener
extends AbstractExportBatchesListener {
    private File exportDir;
    private boolean flattenUri = false;
    private String uriPrefix;

    public ExportBatchesToZipsListener(File exportDir) {
        this.withFilenameExtension(".zip");
        this.exportDir = exportDir;
        this.exportDir.mkdirs();
    }

    @Override
    protected void exportBatch(QueryBatch queryBatch) {
        File file = this.getFileForBatch(queryBatch, this.exportDir);
        WriteToZipConsumer consumer = new WriteToZipConsumer(file);
        this.prepareWriteToZipConsumer(consumer);
        ExportListener listener = new ExportListener();
        listener.onDocumentReady((Consumer)consumer);
        this.prepareExportListener(listener);
        listener.processEvent(queryBatch);
        consumer.close();
    }

    protected void prepareWriteToZipConsumer(WriteToZipConsumer writeToZipConsumer) {
        writeToZipConsumer.setFlattenUri(this.flattenUri);
        if (this.uriPrefix != null) {
            writeToZipConsumer.setUriPrefix(this.uriPrefix);
        }
    }

    public ExportBatchesToZipsListener withFlattenUri(boolean flattenUri) {
        this.flattenUri = flattenUri;
        return this;
    }

    public ExportBatchesToZipsListener withUriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
        return this;
    }
}

