/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.listener;

import com.marklogic.client.datamovement.ExportToWriterListener;
import com.marklogic.client.document.DocumentRecord;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.IOException;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XmlOutputListener
implements ExportToWriterListener.OutputListener {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean omitXmlDeclaration = true;

    public String generateOutput(DocumentRecord documentRecord) {
        if (Format.XML.equals((Object)documentRecord.getFormat())) {
            DOMHandle handle = (DOMHandle)documentRecord.getContent((AbstractReadHandle)new DOMHandle());
            Document document = handle.get();
            OutputFormat format = new OutputFormat(handle.get());
            format.setOmitXMLDeclaration(this.omitXmlDeclaration);
            StringWriter writer = new StringWriter();
            try {
                new XMLSerializer(writer, format).serialize(document);
                return writer.toString();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to serialize XML document to string: " + e.getMessage(), e);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Document '%s' has a format of '%s', so will not attempt to remove the XML declaration from it", documentRecord.getUri(), documentRecord.getFormat().name()));
        }
        return ((StringHandle)documentRecord.getContent((AbstractReadHandle)new StringHandle())).get();
    }

    public void setOmitXmlDeclaration(boolean omitXmlDeclaration) {
        this.omitXmlDeclaration = omitXmlDeclaration;
    }
}

