/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.eval.ServerEvaluationCall;
import com.marklogic.client.ext.datamovement.QueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.util.EvalResultIterator;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrisQueryQueryBatcherBuilder
implements QueryBatcherBuilder {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String xquery;
    private String javascript;
    private boolean wrapQueryIfAppropriate = true;

    public UrisQueryQueryBatcherBuilder(String query) {
        if (query.contains("cts:")) {
            this.xquery = query;
        } else {
            this.javascript = query;
        }
    }

    protected UrisQueryQueryBatcherBuilder() {
    }

    public static UrisQueryQueryBatcherBuilder withXquery(String xquery) {
        UrisQueryQueryBatcherBuilder b = new UrisQueryQueryBatcherBuilder();
        b.xquery = xquery;
        return b;
    }

    public static UrisQueryQueryBatcherBuilder withJavascript(String javascript) {
        UrisQueryQueryBatcherBuilder b = new UrisQueryQueryBatcherBuilder();
        b.javascript = javascript;
        return b;
    }

    @Override
    public QueryBatcher buildQueryBatcher(DatabaseClient databaseClient, DataMovementManager dataMovementManager) {
        ServerEvaluationCall call = databaseClient.newServerEval();
        if (this.javascript != null) {
            if (this.wrapQueryIfAppropriate) {
                this.javascript = this.wrapJavascriptIfAppropriate(this.javascript);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Calling JavaScript: " + this.javascript);
            }
            call = call.javascript(this.javascript);
        } else if (this.xquery != null) {
            if (this.wrapQueryIfAppropriate) {
                this.xquery = this.wrapXqueryIfAppropriate(this.xquery);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Calling XQuery: " + this.xquery);
            }
            call = call.xquery(this.xquery);
        } else {
            throw new IllegalStateException("Either xquery or javascript must be defined");
        }
        return dataMovementManager.newQueryBatcher((Iterator)new EvalResultIterator(call.eval().iterator()));
    }

    protected String wrapXqueryIfAppropriate(String query) {
        if (query.startsWith("cts:") && !query.startsWith("cts:uris")) {
            return String.format("cts:uris((), (), %s)", query);
        }
        return query;
    }

    protected String wrapJavascriptIfAppropriate(String query) {
        if (query.startsWith("cts.") && !query.startsWith("cts.uris")) {
            return String.format("cts.uris(\"\", null, %s)", query);
        }
        return query;
    }

    public void setWrapQueryIfAppropriate(boolean wrapQueryIfAppropriate) {
        this.wrapQueryIfAppropriate = wrapQueryIfAppropriate;
    }
}

