/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.job;

import com.marklogic.client.ext.datamovement.job.AbstractQueryBatcherJob;
import com.marklogic.client.ext.datamovement.listener.AddPermissionsListener;
import java.util.Arrays;

public class AddPermissionsJob
extends AbstractQueryBatcherJob {
    private String[] rolesAndCapabilities;

    public AddPermissionsJob() {
        this.addRequiredJobProperty("permissions", "Comma-delimited list of roles and capabilities defining permissions added to selected records", value -> this.setRolesAndCapabilities(value.split(",")));
    }

    public AddPermissionsJob(String ... rolesAndCapabilities) {
        this();
        this.setRolesAndCapabilities(rolesAndCapabilities);
    }

    @Override
    protected String getJobDescription() {
        return "Adding permissions " + Arrays.asList(this.rolesAndCapabilities) + " to documents " + this.getQueryDescription();
    }

    public void setRolesAndCapabilities(String ... rolesAndCapabilities) {
        this.rolesAndCapabilities = rolesAndCapabilities;
        this.addUrisReadyListener(new AddPermissionsListener(rolesAndCapabilities));
    }
}

