/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types;

import com.marklogic.xcc.types.ValueType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public abstract class ItemType
extends ValueType {
    private static final Map<String, ItemType> typeMap = new HashMap<String, ItemType>();

    ItemType(String name) {
        super(name);
    }

    @Override
    public final boolean isSequence() {
        return false;
    }

    public abstract boolean isNode();

    public abstract boolean isAtomic();

    public static ItemType forType(String schemaTypeName) {
        return typeMap.get(schemaTypeName);
    }

    static {
        Field[] fields = ValueType.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            Object value = null;
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                value = field.get(NODE);
                if (!(value instanceof ItemType)) continue;
                typeMap.put(value.toString(), (ItemType)value);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

