/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.io.IOHelper;
import com.marklogic.xcc.ModuleInvoke;
import com.marklogic.xcc.ModuleSpawn;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.impl.RequestImpl;
import com.marklogic.xcc.types.XName;
import com.marklogic.xcc.types.XdmVariable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ModuleImpl
extends RequestImpl
implements ModuleInvoke,
ModuleSpawn {
    public static final String OLD_STYLE_MODULE_INVOKE_PROP = "xcc.module.invoke.oldstyle";
    private final boolean spawn;
    private String moduleUri;
    private String moduleRoot;
    private boolean oldEncodingStyle = false;

    public ModuleImpl(Session session, String moduleUri, String moduleRoot, RequestOptions options, boolean spawn) {
        super(session, options);
        this.moduleUri = moduleUri;
        this.moduleRoot = moduleRoot;
        this.spawn = spawn;
        if (System.getProperty(OLD_STYLE_MODULE_INVOKE_PROP, "false").equals("true")) {
            this.oldEncodingStyle = true;
        }
    }

    public ModuleImpl(Session session, String moduleUri, RequestOptions options, boolean spawn) {
        this(session, moduleUri, null, options, spawn);
    }

    @Override
    public void setModuleUri(String uri) {
        this.moduleUri = uri;
    }

    @Override
    public String getModuleUri() {
        return this.moduleUri;
    }

    public String getModuleRoot() {
        return this.moduleRoot;
    }

    public void setModuleRoot(String moduleRoot) {
        this.moduleRoot = moduleRoot;
    }

    public boolean isOldEncodingStyle() {
        return this.oldEncodingStyle;
    }

    public void setOldEncodingStyle(boolean oldEncodingStyle) {
        this.oldEncodingStyle = oldEncodingStyle;
    }

    @Override
    String requestVar() {
        if (this.oldEncodingStyle) {
            return "xquery";
        }
        return "module";
    }

    @Override
    String serverPath() {
        if (this.oldEncodingStyle) {
            return "/eval";
        }
        return this.spawn ? "/spawn" : "/invoke";
    }

    @Override
    void urlEncodeXQueryString(StringBuffer sb, Logger logger) {
        if (this.oldEncodingStyle) {
            XdmVariable[] vars = this.getVariables();
            Map<String, String> qnameMap = this.generateQNameMap(vars);
            StringBuffer modcall = new StringBuffer();
            modcall.append("xquery version '0.9-ml'\n");
            this.putPrologue(modcall, vars, qnameMap);
            this.putFunctionCall(modcall, this.getModuleUri(), this.getSession().getContentBaseName(), vars, qnameMap);
            IOHelper.urlEncodeToStringBuffer(sb, modcall.toString());
        } else {
            IOHelper.urlEncodeToStringBuffer(sb, this.moduleUri);
        }
    }

    private void putPrologue(StringBuffer sb, XdmVariable[] vars, Map<String, String> qnameMap) {
        for (Map.Entry<String, String> entry : qnameMap.entrySet()) {
            String ns = entry.getKey();
            String prefix = entry.getValue();
            sb.append("declare namespace ");
            sb.append(prefix).append("=\"").append(ns).append("\"\n");
        }
        if (qnameMap.size() != 0) {
            sb.append("\n");
        }
        for (int i = 0; i < vars.length; ++i) {
            XdmVariable var = vars[i];
            String argName = ModuleImpl.generateQName(qnameMap, var.getName());
            sb.append("define variable $");
            sb.append(argName);
            sb.append(" as ");
            sb.append(var.getValue().getValueType().toString());
            sb.append(" external\n");
        }
        if (vars.length != 0) {
            sb.append("\n");
        }
    }

    private void putFunctionCall(StringBuffer sb, String uri, String contentBase, XdmVariable[] vars, Map<String, String> qnameMap) {
        String functionRoot = this.spawn ? "xdmp:spawn" : "xdmp:invoke";
        sb.append(functionRoot);
        if (contentBase != null) {
            sb.append("-in");
        }
        sb.append(" (\"").append(uri).append("\"");
        if (contentBase != null) {
            sb.append(", ");
            if (this.isName(contentBase)) {
                sb.append("xdmp:database (\"");
                sb.append(contentBase);
                sb.append("\")");
            } else {
                sb.append(contentBase);
            }
        }
        sb.append(", (");
        for (int i = 0; i < vars.length; ++i) {
            XdmVariable var = vars[i];
            String argName = ModuleImpl.generateQName(qnameMap, var.getName());
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("(xs:QName(\"").append(argName).append("\"), ");
            sb.append("$").append(argName).append(")");
        }
        sb.append("), xdmp:modules-database()");
        if (this.getModuleRoot() != null) {
            sb.append(", \"").append(this.getModuleRoot()).append("\"");
        }
        sb.append(")");
    }

    private Map<String, String> generateQNameMap(XdmVariable[] vars) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < vars.length; ++i) {
            XdmVariable var = vars[i];
            XName varName = var.getName();
            String ns = varName.getNamespace();
            if (ns == null || map.get(ns) != null) continue;
            map.put(ns, "tmpq" + i);
        }
        return map;
    }

    private static String generateQName(Map<String, String> tmpQNames, XName arg) {
        String ns;
        String string = ns = arg.getNamespace() == null ? "" : arg.getNamespace();
        if (ns.length() == 0) {
            return arg.getLocalname();
        }
        return "" + tmpQNames.get(ns) + ":" + arg.getLocalname();
    }
}

